/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.MigratingProcessInstanceValidationReportAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationHorizontalScopeChangeTest {
    protected ProcessEngineRule rule = new ProcessEngineRule(true);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testCannotMigrateHorizontallyBetweenScopes() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask2").mapActivities("userTask2", "userTask1").build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasActivityInstanceFailures("userTask1", "Closest migrating ancestor activity instance is migrated to activity 'subProcess1' which is not an ancestor of target activity 'userTask2'").hasActivityInstanceFailures("userTask2", "Closest migrating ancestor activity instance is migrated to activity 'subProcess2' which is not an ancestor of target activity 'userTask1'");
        }
    }
}

