/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MultiInstanceProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationMultiInstanceTest {
    public static final String NUMBER_OF_INSTANCES = "nrOfInstances";
    public static final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    public static final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    public static final String LOOP_COUNTER = "loopCounter";
    protected ProcessEngineRule rule = new ProcessEngineRule(true);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateParallelMultiInstanceTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration(this.miBodyOf("userTask"))).child("userTask").concurrent().noScope().up().child("userTask").concurrent().noScope().up().child("userTask").concurrent().noScope().up().done());
        ActivityInstance[] userTaskInstances = this.testHelper.snapshotBeforeMigration.getActivityTree().getActivityInstances("userTask");
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginMiBody("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration(this.miBodyOf("userTask")).getId()).activity("userTask", userTaskInstances[0].getId()).activity("userTask", userTaskInstances[1].getId()).activity("userTask", userTaskInstances[2].getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)3L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateParallelMultiInstanceTasksVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        List tasksBeforeMigration = this.rule.getTaskService().createTaskQuery().list();
        HashMap<String, Integer> loopCounterDistribution = new HashMap<String, Integer>();
        for (Task task : tasksBeforeMigration) {
            Integer loopCounter = (Integer)this.rule.getTaskService().getVariable(task.getId(), LOOP_COUNTER);
            loopCounterDistribution.put(task.getId(), loopCounter);
        }
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List<Task> tasks = this.testHelper.snapshotAfterMigration.getTasks();
        Task firstTask = tasks.get(0);
        Assert.assertEquals((Object)3, (Object)this.rule.getTaskService().getVariable(firstTask.getId(), NUMBER_OF_INSTANCES));
        Assert.assertEquals((Object)3, (Object)this.rule.getTaskService().getVariable(firstTask.getId(), NUMBER_OF_ACTIVE_INSTANCES));
        Assert.assertEquals((Object)0, (Object)this.rule.getTaskService().getVariable(firstTask.getId(), NUMBER_OF_COMPLETED_INSTANCES));
        for (Task task : tasks) {
            Integer loopCounter = (Integer)this.rule.getTaskService().getVariable(task.getId(), LOOP_COUNTER);
            Assert.assertNotNull((Object)loopCounter);
            Assert.assertEquals(loopCounterDistribution.get(task.getId()), (Object)loopCounter);
        }
    }

    @Test
    public void testMigrateParallelMultiInstancePartiallyComplete() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeAnyTask("userTask");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration(this.miBodyOf("userTask"))).child("userTask").concurrent().noScope().up().child("userTask").concurrent().noScope().up().child("userTask").concurrent().noScope().up().done());
        ActivityInstance[] userTaskInstances = this.testHelper.snapshotBeforeMigration.getActivityTree().getActivityInstances("userTask");
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginMiBody("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration(this.miBodyOf("userTask")).getId()).activity("userTask", userTaskInstances[0].getId()).activity("userTask", userTaskInstances[1].getId()).transition("userTask").done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateParallelMiBodyRemoveSubprocess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("subProcess"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures(this.miBodyOf("subProcess"), "Cannot remove the inner activity of a multi-instance body when the body migrates");
        }
    }

    @Test
    public void testMigrateParallelMiBodyAddSubprocess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_SUBPROCESS_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("subProcess")).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures(this.miBodyOf("userTask"), "Must migrate the inner activity of a multi-instance body when the body migrates");
        }
    }

    @Test
    public void testMigrateSequentialMultiInstanceTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration(this.miBodyOf("userTask"))).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginMiBody("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration(this.miBodyOf("userTask")).getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSequentialMultiInstanceTasksVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Task task = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertEquals((Object)3, (Object)this.rule.getTaskService().getVariable(task.getId(), NUMBER_OF_INSTANCES));
        Assert.assertEquals((Object)1, (Object)this.rule.getTaskService().getVariable(task.getId(), NUMBER_OF_ACTIVE_INSTANCES));
        Assert.assertEquals((Object)0, (Object)this.rule.getTaskService().getVariable(task.getId(), NUMBER_OF_COMPLETED_INSTANCES));
        Assert.assertEquals((Object)0, (Object)this.rule.getTaskService().getVariable(task.getId(), NUMBER_OF_COMPLETED_INSTANCES));
    }

    @Test
    public void testMigrateSequentialMultiInstancePartiallyComplete() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeAnyTask("userTask");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration(this.miBodyOf("userTask"))).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginMiBody("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration(this.miBodyOf("userTask")).getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSequenatialMiBodyRemoveSubprocess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("subProcess"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures(this.miBodyOf("subProcess"), "Cannot remove the inner activity of a multi-instance body when the body migrates");
        }
    }

    @Test
    public void testMigrateSequentialMiBodyAddSubprocess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_SUBPROCESS_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("subProcess")).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures(this.miBodyOf("userTask"), "Must migrate the inner activity of a multi-instance body when the body migrates");
        }
    }

    @Test
    public void testMigrateParallelToSequential() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(this.miBodyOf("userTask"), this.miBodyOf("userTask")).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures(this.miBodyOf("userTask"), "Source and target activity must be of the same multi-instance type (sequential or parallel)");
        }
    }

    protected String miBodyOf(String activityId) {
        return activityId + "#multiInstanceBody";
    }
}

