/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.MigrationPlanAssert;
import org.camunda.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationPlanCreationTest {
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String ERROR_CODE = "Error";
    public static final String ESCALATION_CODE = "Escalation";
    protected ProcessEngineRule rule = new ProcessEngineRule(true);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
    }

    @Test
    public void testExplicitInstructionGeneration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMigrateNonExistingSourceDefinition() {
        ProcessDefinition processDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan("aNonExistingProcDefId", processDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (BadUserRequestException e) {
            this.assertExceptionMessage((Exception)((Object)e), "source process definition with id aNonExistingProcDefId does not exist");
        }
    }

    @Test
    public void testMigrateNullSourceDefinition() {
        ProcessDefinition processDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(null, processDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (BadUserRequestException e) {
            this.assertExceptionMessage((Exception)((Object)e), "sourceProcessDefinitionId is null");
        }
    }

    @Test
    public void testMigrateNonExistingTargetDefinition() {
        ProcessDefinition processDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(processDefinition.getId(), "aNonExistingProcDefId").mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (BadUserRequestException e) {
            this.assertExceptionMessage((Exception)((Object)e), "target process definition with id aNonExistingProcDefId does not exist");
        }
    }

    @Test
    public void testMigrateNullTargetDefinition() {
        ProcessDefinition processDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(processDefinition.getId(), null).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (BadUserRequestException e) {
            this.assertExceptionMessage((Exception)((Object)e), "targetProcessDefinitionId is null");
        }
    }

    @Test
    public void testMigrateNonExistingSourceActivityId() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("thisActivityDoesNotExist", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("thisActivityDoesNotExist", "Source activity 'thisActivityDoesNotExist' does not exist");
        }
    }

    @Test
    public void testMigrateNullSourceActivityId() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities(null, "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures(null, "Source activity id is null");
        }
    }

    @Test
    public void testMigrateNonExistingTargetActivityId() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "thisActivityDoesNotExist").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity 'thisActivityDoesNotExist' does not exist");
        }
    }

    @Test
    public void testMigrateNullTargetActivityId() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", null).build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity id is null");
        }
    }

    @Test
    public void testMigrateTaskToHigherScope() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceDefinition).hasTargetProcessDefinition(targetDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMigrateToUnsupportedActivityType() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deploy(ProcessModels.ONE_RECEIVE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "receiveTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Type of the target activity 'receiveTask' is not supported by the migration", "Activities are of different type which is not supported by the migration (userTask != receiveTask)");
        }
    }

    @Test
    public void testNotMigrateActivitiesOfDifferentType() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).swapElementIds("userTask", "subProcess"));
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Activities are of different type which is not supported by the migration (userTask != subProcess)");
        }
    }

    @Test
    public void testNotMigrateBoundaryEventsOfDifferentType() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done());
        ProcessDefinition targetDefinition = this.testHelper.deploy(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).done());
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("boundary", "Activities are of different type which is not supported by the migration (boundaryMessage != boundarySignal)");
        }
    }

    @Test
    public void testMigrateSubProcessToProcessDefinition() {
        ProcessDefinition sourceDefinition = this.testHelper.deploy("oneTaskProcess.bpmn20.xml", ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deploy("oneTaskProcess.bpmn20.xml", ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("subProcess", targetDefinition.getId()).build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("subProcess", "Target activity '" + targetDefinition.getId() + "' does not exist");
        }
    }

    @Test
    public void testMapEqualActivitiesWithParallelMultiInstance() {
        BpmnModelInstance testProcess = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).getBuilderForElementById("userTask", UserTaskBuilder.class).multiInstance().parallel()).cardinality("3")).multiInstanceDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity 'userTask' is a descendant of multi-instance body 'userTask#multiInstanceBody' that is not migrated from the source process definition.");
        }
    }

    @Test
    public void testMapEqualBoundaryEvents() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("boundary").to("boundary"));
    }

    @Test
    public void testMapBoundaryEventsWithDifferentId() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("boundary").to("newBoundary"));
    }

    @Test
    public void testMapBoundaryToMigratedActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("userTask", "newUserTask");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "newUserTask").mapActivities("boundary", "boundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("newUserTask"), MigrationPlanAssert.migrate("boundary").to("boundary"));
    }

    @Test
    public void testNotMapBoundaryToParallelActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask2").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").mapActivities("boundary", "boundary").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("boundary", "Event scope of the activity has changed and wasn't migrated");
        }
    }

    @Test
    public void testMapBoundaryToHigherScope() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("boundary").to("boundary"));
    }

    @Test
    public void testMapBoundaryToLowerScope() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("boundary").to("boundary"));
    }

    @Test
    public void testNotMapBoundaryToChildActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("boundary", "Event scope of the activity has changed and wasn't migrated");
        }
    }

    @Test
    public void testNotMapBoundaryToParentActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("boundary", "Event scope of the activity has changed and wasn't migrated");
        }
    }

    @Test
    public void testNotMapUnsupportedBoundaryEvents() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("error").error(ERROR_CODE)).moveToActivity("subProcess").boundaryEvent("escalation").escalation(ESCALATION_CODE)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("error", "error").mapActivities("escalation", "escalation").mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("error", "Type of the source boundary event 'error' is not supported by migration", "Type of the target boundary event 'error' is not supported by migration").hasInstructionFailures("escalation", "Type of the source boundary event 'escalation' is not supported by migration", "Type of the target boundary event 'escalation' is not supported by migration");
        }
    }

    @Test
    public void testNotMapProcessDefinitionWithEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Source activity 'userTask' has an event sub process child", "Target activity 'userTask' has an event sub process child");
        }
    }

    @Test
    public void testNotMapSubProcessWithEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("subProcess", "Source activity 'subProcess' has an event sub process child", "Target activity 'subProcess' has an event sub process child");
        }
    }

    @Test
    public void testMapActivityWithUnmappedParentWhichHasAEventSubProcessChild() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testNotMapUserTaskInEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).userTask("innerTask").endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("innerTask", "innerTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("innerTask", "Source activity 'innerTask' is child of an event sub process", "Target activity 'innerTask' is child of an event sub process");
        }
    }

    @Test
    public void testNotMapActivitiesMoreThanOnce() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask1", "userTask2").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask1", "There are multiple mappings for source activity id 'userTask1'", "There are multiple mappings for source activity id 'userTask1'");
        }
    }

    protected void assertExceptionMessage(Exception e, String message) {
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)message));
    }
}

