/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MultiInstanceProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.MigrationPlanAssert;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationPlanGenerationTest {
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    public static final String ERROR_CODE = "Error";
    public static final String ESCALATION_CODE = "Escalation";
    protected ProcessEngineRule rule = new ProcessEngineRule(true);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMapEqualActivitiesInProcessDefinitionScope() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesInSameSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesToSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToNestedSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.DOUBLE_SUBPROCESS_PROCESS).changeElementId("outerSubProcess", "subProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"));
    }

    @Test
    public void testMapEqualActivitiesToSurroundingSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.DOUBLE_SUBPROCESS_PROCESS).changeElementId("innerSubProcess", "subProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToDeeplyNestedSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.DOUBLE_SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToSiblingScope() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).swapElementIds("userTask1", "userTask2");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess1").to("subProcess1"), MigrationPlanAssert.migrate("subProcess2").to("subProcess2"));
    }

    @Test
    public void testMapEqualActivitiesToNestedSiblingScope() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_DOUBLE_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_DOUBLE_SUBPROCESS_PROCESS).swapElementIds("userTask1", "userTask2");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess1").to("subProcess1"), MigrationPlanAssert.migrate("nestedSubProcess1").to("nestedSubProcess1"), MigrationPlanAssert.migrate("subProcess2").to("subProcess2"), MigrationPlanAssert.migrate("nestedSubProcess2").to("nestedSubProcess2"));
    }

    @Test
    public void testMapEqualActivitiesWhichBecomeScope() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.SCOPE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesWithParallelMultiInstance() {
        BpmnModelInstance testProcess = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((UserTask)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).getModelElementById("userTask")).builder().multiInstance().parallel()).cardinality("3")).multiInstanceDone().done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("userTask#multiInstanceBody").to("userTask#multiInstanceBody"));
    }

    @Test
    public void testMapEqualActivitiesIgnoreUnsupportedActivities() {
        BpmnModelInstance sourceProcess = ProcessModels.UNSUPPORTED_ACTIVITIES;
        BpmnModelInstance targetProcess = ProcessModels.UNSUPPORTED_ACTIVITIES;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToParentScope() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.DOUBLE_SUBPROCESS_PROCESS).changeElementId("outerSubProcess", "subProcess");
        BpmnModelInstance targetProcess = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"));
    }

    @Test
    public void testMapEqualActivitiesFromScopeToProcessDefinition() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesFromDoubleScopeToProcessDefinition() {
        BpmnModelInstance sourceProcess = ProcessModels.DOUBLE_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesFromTripleScopeToProcessDefinition() {
        BpmnModelInstance sourceProcess = ProcessModels.TRIPLE_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesFromTripleScopeToSingleNewScope() {
        BpmnModelInstance sourceProcess = ProcessModels.TRIPLE_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesFromTripleScopeToTwoNewScopes() {
        BpmnModelInstance sourceProcess = ProcessModels.TRIPLE_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.DOUBLE_SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToNewScopes() {
        BpmnModelInstance sourceProcess = ProcessModels.DOUBLE_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.DOUBLE_SUBPROCESS_PROCESS).changeElementId("outerSubProcess", "newOuterSubProcess").changeElementId("innerSubProcess", "newInnerSubProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesOutsideOfScope() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.PARALLEL_TASK_AND_SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask1").to("userTask1"));
    }

    @Test
    public void testMapEqualActivitiesToHorizontalScope() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_TASK_AND_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask1").to("userTask1"));
    }

    @Test
    public void testMapEqualActivitiesFromTaskWithBoundaryEvent() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent(null).message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesToTaskWithBoundaryEvent() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent(null).message(MESSAGE_NAME)).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesWithBoundaryEvent() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("messageBoundary").message(MESSAGE_NAME)).moveToActivity("userTask").boundaryEvent("signalBoundary").signal(SIGNAL_NAME)).moveToActivity("userTask").boundaryEvent("timerBoundary").timerWithDate(TIMER_DATE)).done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("messageBoundary").to("messageBoundary"), MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("signalBoundary").to("signalBoundary"), MigrationPlanAssert.migrate("timerBoundary").to("timerBoundary"));
    }

    @Test
    public void testNotMapBoundaryEventsWithDifferentIds() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("message").message(MESSAGE_NAME)).done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("message", "newMessage");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testIgnoreNotSupportedBoundaryEvents() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("messageBoundary").message(MESSAGE_NAME)).moveToActivity("subProcess").boundaryEvent("errorBoundary").error(ERROR_CODE)).moveToActivity("subProcess").boundaryEvent("escalationBoundary").escalation(ESCALATION_CODE)).moveToActivity("userTask").boundaryEvent("signalBoundary").signal(SIGNAL_NAME)).done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("messageBoundary").to("messageBoundary"), MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("signalBoundary").to("signalBoundary"));
    }

    @Test
    public void testNotMigrateBoundaryToParallelActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("message").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask2").boundaryEvent("message").message(MESSAGE_NAME)).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask1").to("userTask1"), MigrationPlanAssert.migrate("userTask2").to("userTask2"));
    }

    @Test
    public void testNotMigrateBoundaryToChildActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("message").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("message").message(MESSAGE_NAME)).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testNotMigrateProcessInstanceWithEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasEmptyInstructions();
        this.assertGeneratedMigrationPlan(testProcess, ProcessModels.ONE_TASK_PROCESS).hasEmptyInstructions();
        this.assertGeneratedMigrationPlan(ProcessModels.ONE_TASK_PROCESS, testProcess).hasEmptyInstructions();
    }

    @Test
    public void testNotMigrateSubProcessWithEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasEmptyInstructions();
        this.assertGeneratedMigrationPlan(testProcess, ProcessModels.SUBPROCESS_PROCESS).hasEmptyInstructions();
        this.assertGeneratedMigrationPlan(ProcessModels.SUBPROCESS_PROCESS, testProcess).hasEmptyInstructions();
    }

    @Test
    public void testNotMigrateUserTaskInEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).userTask("innerTask").endEvent().subProcessDone().done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasEmptyInstructions();
        this.assertGeneratedMigrationPlan(testProcess, ProcessModels.SUBPROCESS_PROCESS).hasEmptyInstructions();
        this.assertGeneratedMigrationPlan(ProcessModels.SUBPROCESS_PROCESS, testProcess).hasEmptyInstructions();
    }

    @Test
    public void testNotMigrateActivitiesOfDifferentType() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).swapElementIds("userTask", "subProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testNotMigrateBoundaryEventsOfDifferentType() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testNotMigrateMultiInstanceOfDifferentType() {
        BpmnModelInstance sourceProcess = MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testNotMigrateBoundaryEventsWithInvalidEventScopeInstruction() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message("foo")).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_RECEIVE_TASK_PROCESS).changeElementId("receiveTask", "userTask").activityBuilder("userTask").boundaryEvent("boundary").message("foo")).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    protected MigrationPlanAssert assertGeneratedMigrationPlan(BpmnModelInstance sourceProcess, BpmnModelInstance targetProcess) {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition);
        return MigrationPlanAssert.assertThat(migrationPlan);
    }
}

