/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Collections;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.MigratingProcessInstanceValidationReportAssert;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationProcessInstanceTest {
    protected ProcessEngineRule rule = new ProcessEngineRule(true);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
    }

    @Test
    public void testNullMigrationPlan() {
        try {
            this.runtimeService.newMigration(null).processInstanceIds(Collections.emptyList()).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"migration plan is null"));
        }
    }

    @Test
    public void testNullProcessInstanceIds() {
        ProcessDefinition testProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(null).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is null"));
        }
    }

    @Test
    public void testNotMigrateProcessInstanceOfWrongProcessDefinition() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition wrongProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(wrongProcessDefinition.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList(processInstance.getId())).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"ENGINE-23002"));
        }
    }

    @Test
    public void testNotMigrateUnknownProcessInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList("unknown")).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"ENGINE-23003"));
        }
    }

    @Test
    public void testNotMigrateNullProcessInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList(null)).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance id is null"));
        }
    }

    @Test
    public void testNotMigrateProcessInstanceWithAsyncTransition() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(((UserTaskBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).userTaskBuilder("userTask").camundaAsyncBefore()).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasFailures("Process instance contains not migrated jobs").hasActivityInstanceFailures(sourceProcessDefinition.getId(), "Has active asynchronous child transitions");
        }
    }

    @Test
    public void testNotMigrateProcessInstanceWithNestedAsyncTransition() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(((UserTaskBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.TRIPLE_SUBPROCESS_PROCESS).userTaskBuilder("userTask").camundaAsyncBefore()).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasFailures("Process instance contains not migrated jobs").hasActivityInstanceFailures("subProcess3", "Has active asynchronous child transitions");
        }
    }
}

