/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshot;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshotBuilder;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class MigrationTestRule
extends TestWatcher {
    public static final String DEFAULT_BPMN_RESOURCE_NAME = "process.bpmn20.xml";
    protected ProcessEngineRule processEngineRule;
    protected ProcessEngine processEngine;
    public ProcessInstanceSnapshot snapshotBeforeMigration;
    public ProcessInstanceSnapshot snapshotAfterMigration;

    public MigrationTestRule(ProcessEngineRule processEngineRule) {
        this.processEngineRule = processEngineRule;
    }

    protected void starting(Description description) {
        this.processEngine = this.processEngineRule.getProcessEngine();
    }

    protected void finished(Description description) {
        this.processEngine = null;
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            Assert.fail((String)("Process instance with id " + processInstanceId + " is not finished"));
        }
    }

    public ProcessDefinition findProcessDefinition(String key, int version) {
        return (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(key).processDefinitionVersion(Integer.valueOf(version)).singleResult();
    }

    public ProcessDefinition deploy(String name, BpmnModelInstance bpmnModel) {
        Deployment deployment = this.processEngine.getRepositoryService().createDeployment().addModelInstance(name, bpmnModel).deploy();
        this.processEngineRule.manageDeployment(deployment);
        return (ProcessDefinition)this.processEngineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
    }

    public ProcessDefinition deploy(BpmnModelInstance bpmnModel) {
        return this.deploy(DEFAULT_BPMN_RESOURCE_NAME, bpmnModel);
    }

    public String getSingleExecutionIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance singleInstance = this.getSingleActivityInstance(activityInstance, activityId);
        String[] executionIds = singleInstance.getExecutionIds();
        if (executionIds.length == 1) {
            return executionIds[0];
        }
        throw new RuntimeException("There is more than one execution assigned to activity instance " + singleInstance.getId());
    }

    public String getSingleExecutionIdForActivityBeforeMigration(String activityId) {
        return this.getSingleExecutionIdForActivity(this.snapshotBeforeMigration.getActivityTree(), activityId);
    }

    public ActivityInstance getSingleActivityInstance(ActivityInstance tree, String activityId) {
        ActivityInstance[] activityInstances = tree.getActivityInstances(activityId);
        if (activityInstances.length == 1) {
            return activityInstances[0];
        }
        throw new RuntimeException("There is not exactly one activity instance for activity " + activityId);
    }

    public ActivityInstance getSingleActivityInstanceBeforeMigration(String activityId) {
        return this.getSingleActivityInstance(this.snapshotBeforeMigration.getActivityTree(), activityId);
    }

    public ActivityInstance getSingleActivityInstanceAfterMigration(String activityId) {
        return this.getSingleActivityInstance(this.snapshotAfterMigration.getActivityTree(), activityId);
    }

    public ProcessInstanceSnapshot takeFullProcessInstanceSnapshot(ProcessInstance processInstance) {
        return this.takeProcessInstanceSnapshot(processInstance).full();
    }

    public ProcessInstanceSnapshotBuilder takeProcessInstanceSnapshot(ProcessInstance processInstance) {
        return new ProcessInstanceSnapshotBuilder(processInstance, this.processEngine);
    }

    public ProcessInstance createProcessInstanceAndMigrate(MigrationPlan migrationPlan) {
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        this.migrateProcessInstance(migrationPlan, processInstance);
        return processInstance;
    }

    public void migrateProcessInstance(MigrationPlan migrationPlan, ProcessInstance processInstance) {
        this.snapshotBeforeMigration = this.takeFullProcessInstanceSnapshot(processInstance);
        this.processEngine.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Collections.singletonList(this.snapshotBeforeMigration.getProcessInstanceId())).execute();
        this.snapshotAfterMigration = this.takeFullProcessInstanceSnapshot(processInstance);
    }

    public void completeTask(String taskKey) {
        TaskService taskService = this.processEngine.getTaskService();
        Task task = (Task)taskService.createTaskQuery().taskDefinitionKey(taskKey).singleResult();
        Assert.assertNotNull((Object)task);
        taskService.complete(task.getId());
    }

    public void completeAnyTask(String taskKey) {
        TaskService taskService = this.processEngine.getTaskService();
        List tasks = taskService.createTaskQuery().taskDefinitionKey(taskKey).list();
        Assert.assertTrue((!tasks.isEmpty() ? 1 : 0) != 0);
        taskService.complete(((Task)tasks.get(0)).getId());
    }

    public void correlateMessage(String messageName) {
        this.processEngine.getRuntimeService().createMessageCorrelation(messageName).correlate();
    }

    public void sendSignal(String signalName) {
        this.processEngine.getRuntimeService().signalEventReceived(signalName);
    }

    public void triggerTimer() {
        Job job = this.assertTimerJobExists(this.snapshotAfterMigration);
        this.processEngine.getManagementService().executeJob(job.getId());
    }

    public ExecutionAssert assertExecutionTreeAfterMigration() {
        return ExecutionAssert.assertThat(this.snapshotAfterMigration.getExecutionTree());
    }

    public ActivityInstanceAssert.ActivityInstanceAssertThatClause assertActivityTreeAfterMigration() {
        return ActivityInstanceAssert.assertThat(this.snapshotAfterMigration.getActivityTree());
    }

    public void assertEventSubscriptionMigrated(String activityIdBefore, String activityIdAfter, String eventName) {
        EventSubscription eventSubscriptionBefore = this.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityIdBefore, eventName);
        Assert.assertNotNull((String)("Expected that an event subscription for activity '" + activityIdBefore + "' exists before migration"), (Object)eventSubscriptionBefore);
        EventSubscription eventSubscriptionAfter = this.snapshotAfterMigration.getEventSubscriptionForActivityIdAndEventName(activityIdAfter, eventName);
        Assert.assertNotNull((String)("Expected that an event subscription for activity '" + activityIdAfter + "' exists after migration"), (Object)eventSubscriptionAfter);
        Assert.assertEquals((Object)eventSubscriptionBefore.getId(), (Object)eventSubscriptionAfter.getId());
        Assert.assertEquals((Object)eventSubscriptionBefore.getEventType(), (Object)eventSubscriptionAfter.getEventType());
    }

    public void assertEventSubscriptionRemoved(String activityId, String eventName) {
        EventSubscription eventSubscriptionBefore = this.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityId, eventName);
        Assert.assertNotNull((String)("Expected an event subscription for activity '" + activityId + "' before the migration"), (Object)eventSubscriptionBefore);
        for (EventSubscription eventSubscription : this.snapshotAfterMigration.getEventSubscriptions()) {
            if (!eventSubscriptionBefore.getId().equals(eventSubscription.getId())) continue;
            Assert.fail((String)("Expected event subscription '" + eventSubscriptionBefore.getId() + "' to be removed after migration"));
        }
    }

    public void assertEventSubscriptionCreated(String activityId, String eventName) {
        EventSubscription eventSubscriptionAfter = this.snapshotAfterMigration.getEventSubscriptionForActivityIdAndEventName(activityId, eventName);
        Assert.assertNotNull((String)("Expected an event subscription for activity '" + activityId + "' after the migration"), (Object)eventSubscriptionAfter);
        for (EventSubscription eventSubscription : this.snapshotBeforeMigration.getEventSubscriptions()) {
            if (!eventSubscriptionAfter.getId().equals(eventSubscription.getId())) continue;
            Assert.fail((String)("Expected event subscription '" + eventSubscriptionAfter.getId() + "' to be created after migration"));
        }
    }

    public void assertTimerJob(Job job) {
        Assert.assertEquals((String)"Expected job to be a timer job", (Object)"timer", (Object)((JobEntity)job).getType());
    }

    public Job assertTimerJobExists(ProcessInstanceSnapshot snapshot) {
        List<Job> jobs = snapshot.getJobs();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = jobs.get(0);
        this.assertTimerJob(job);
        return job;
    }

    public void assertJobCreated(String activityId, String handlerType) {
        JobDefinition jobDefinitionAfter = this.snapshotAfterMigration.getJobDefinitionForActivityIdAndType(activityId, handlerType);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityId + "' exists after migration"), (Object)jobDefinitionAfter);
        Job jobAfter = this.snapshotAfterMigration.getJobForDefinitionId(jobDefinitionAfter.getId());
        Assert.assertNotNull((String)("Expected that a job for activity '" + activityId + "' exists after migration"), (Object)jobAfter);
        this.assertTimerJob(jobAfter);
        for (Job job : this.snapshotBeforeMigration.getJobs()) {
            if (!jobAfter.getId().equals(job.getId())) continue;
            Assert.fail((String)("Expected job '" + jobAfter.getId() + "' to be created first after migration"));
        }
    }

    public void assertJobRemoved(String activityId, String handlerType) {
        JobDefinition jobDefinitionBefore = this.snapshotBeforeMigration.getJobDefinitionForActivityIdAndType(activityId, handlerType);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityId + "' exists before migration"), (Object)jobDefinitionBefore);
        Job jobBefore = this.snapshotBeforeMigration.getJobForDefinitionId(jobDefinitionBefore.getId());
        Assert.assertNotNull((String)("Expected that a job for activity '" + activityId + "' exists before migration"), (Object)jobBefore);
        this.assertTimerJob(jobBefore);
        for (Job job : this.snapshotAfterMigration.getJobs()) {
            if (!jobBefore.getId().equals(job.getId())) continue;
            Assert.fail((String)("Expected job '" + jobBefore.getId() + "' to be removed after migration"));
        }
    }

    public void assertJobMigrated(String activityIdBefore, String activityIdAfter, String handlerType) {
        JobDefinition jobDefinitionBefore = this.snapshotBeforeMigration.getJobDefinitionForActivityIdAndType(activityIdBefore, handlerType);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityIdBefore + "' exists before migration"), (Object)jobDefinitionBefore);
        Job jobBefore = this.snapshotBeforeMigration.getJobForDefinitionId(jobDefinitionBefore.getId());
        Assert.assertNotNull((String)("Expected that a timer job for activity '" + activityIdBefore + "' exists before migration"), (Object)jobBefore);
        this.assertTimerJob(jobBefore);
        JobDefinition jobDefinitionAfter = this.snapshotAfterMigration.getJobDefinitionForActivityIdAndType(activityIdAfter, handlerType);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityIdAfter + "' exists after migration"), (Object)jobDefinitionAfter);
        Job jobAfter = this.snapshotAfterMigration.getJobForDefinitionId(jobDefinitionAfter.getId());
        Assert.assertNotNull((String)("Expected that a timer job for activity '" + activityIdAfter + "' exists after migration"), (Object)jobAfter);
        this.assertTimerJob(jobAfter);
        Assert.assertEquals((Object)jobBefore.getId(), (Object)jobAfter.getId());
        Assert.assertEquals((Object)jobBefore.getDuedate(), (Object)jobAfter.getDuedate());
        Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionId(), (Object)jobAfter.getProcessDefinitionId());
        Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionKey(), (Object)jobAfter.getProcessDefinitionKey());
    }

    public void assertBoundaryTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-transition");
    }

    public void assertBoundaryTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-transition");
    }

    public void assertBoundaryTimerJobMigrated(String activityIdBefore, String activityIdAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-transition");
    }

    public void assertEventSubProcessTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-start-event-subprocess");
    }

    public void assertEventSubProcessTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-start-event-subprocess");
    }

    public void assertVariableMigratedToExecution(VariableInstance variableBefore, String executionId) {
        this.assertVariableMigratedToExecution(variableBefore, executionId, variableBefore.getActivityInstanceId());
    }

    public void assertVariableMigratedToExecution(VariableInstance variableBefore, String executionId, String activityInstanceId) {
        VariableInstance variableAfter = this.snapshotAfterMigration.getVariable(variableBefore.getId());
        Assert.assertNotNull((String)("Variable with id " + variableBefore.getId() + " does not exist"), (Object)variableAfter);
        Assert.assertEquals((Object)activityInstanceId, (Object)variableAfter.getActivityInstanceId());
        Assert.assertEquals((Object)variableBefore.getCaseExecutionId(), (Object)variableAfter.getCaseExecutionId());
        Assert.assertEquals((Object)variableBefore.getCaseInstanceId(), (Object)variableAfter.getCaseInstanceId());
        Assert.assertEquals((Object)variableBefore.getErrorMessage(), (Object)variableAfter.getErrorMessage());
        Assert.assertEquals((Object)executionId, (Object)variableAfter.getExecutionId());
        Assert.assertEquals((Object)variableBefore.getId(), (Object)variableAfter.getId());
        Assert.assertEquals((Object)variableBefore.getName(), (Object)variableAfter.getName());
        Assert.assertEquals((Object)variableBefore.getProcessInstanceId(), (Object)variableAfter.getProcessInstanceId());
        Assert.assertEquals((Object)variableBefore.getTaskId(), (Object)variableAfter.getTaskId());
        Assert.assertEquals((Object)variableBefore.getTenantId(), (Object)variableAfter.getTenantId());
        Assert.assertEquals((Object)variableBefore.getTypeName(), (Object)variableAfter.getTypeName());
        Assert.assertEquals((Object)variableBefore.getValue(), (Object)variableAfter.getValue());
    }
}

