/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.AbstractBaseElementBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.Definitions;
import org.camunda.bpm.model.bpmn.instance.SubProcess;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class ModifiableBpmnModelInstance
implements BpmnModelInstance {
    protected BpmnModelInstance modelInstance;

    public ModifiableBpmnModelInstance(BpmnModelInstance modelInstance) {
        this.modelInstance = modelInstance;
    }

    public static ModifiableBpmnModelInstance modify(BpmnModelInstance modelInstance) {
        return new ModifiableBpmnModelInstance(modelInstance.clone());
    }

    public Definitions getDefinitions() {
        return this.modelInstance.getDefinitions();
    }

    public void setDefinitions(Definitions definitions) {
        this.modelInstance.setDefinitions(definitions);
    }

    public BpmnModelInstance clone() {
        return this.modelInstance.clone();
    }

    public DomDocument getDocument() {
        return this.modelInstance.getDocument();
    }

    public ModelElementInstance getDocumentElement() {
        return this.modelInstance.getDocumentElement();
    }

    public void setDocumentElement(ModelElementInstance documentElement) {
        this.modelInstance.setDocumentElement(documentElement);
    }

    public <T extends ModelElementInstance> T newInstance(Class<T> type) {
        return (T)this.modelInstance.newInstance(type);
    }

    public <T extends ModelElementInstance> T newInstance(ModelElementType type) {
        return (T)this.modelInstance.newInstance(type);
    }

    public Model getModel() {
        return this.modelInstance.getModel();
    }

    public <T extends ModelElementInstance> T getModelElementById(String id) {
        return (T)this.modelInstance.getModelElementById(id);
    }

    public Collection<ModelElementInstance> getModelElementsByType(ModelElementType referencingType) {
        return this.modelInstance.getModelElementsByType(referencingType);
    }

    public <T extends ModelElementInstance> Collection<T> getModelElementsByType(Class<T> referencingClass) {
        return this.modelInstance.getModelElementsByType(referencingClass);
    }

    public <T extends AbstractBaseElementBuilder> T getBuilderForElementById(String id, Class<T> builderClass) {
        BaseElement modelElementById = (BaseElement)this.modelInstance.getModelElementById(id);
        return (T)modelElementById.builder();
    }

    public AbstractActivityBuilder activityBuilder(String activityId) {
        return this.getBuilderForElementById(activityId, AbstractActivityBuilder.class);
    }

    public UserTaskBuilder userTaskBuilder(String userTaskId) {
        return this.getBuilderForElementById(userTaskId, UserTaskBuilder.class);
    }

    public EndEventBuilder endEventBuilder(String eventId) {
        return this.getBuilderForElementById(eventId, EndEventBuilder.class);
    }

    public ModifiableBpmnModelInstance changeElementId(String oldId, String newId) {
        BaseElement element = (BaseElement)this.getModelElementById(oldId);
        element.setId(newId);
        return this;
    }

    public ModifiableBpmnModelInstance swapElementIds(String firstElementId, String secondElementId) {
        BaseElement firstElement = (BaseElement)this.getModelElementById(firstElementId);
        BaseElement secondElement = (BaseElement)this.getModelElementById(secondElementId);
        secondElement.setId("___TEMP___ID___");
        firstElement.setId(secondElementId);
        secondElement.setId(firstElementId);
        return this;
    }

    public SubProcessBuilder addSubProcessTo(String parentId) {
        SubProcess eventSubProcess = (SubProcess)this.modelInstance.newInstance(SubProcess.class);
        BpmnModelElementInstance parent = (BpmnModelElementInstance)this.getModelElementById(parentId);
        parent.addChildElement((ModelElementInstance)eventSubProcess);
        return eventSubProcess.builder();
    }
}

