/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.batch;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.junit.Assert;

public class BatchMigrationHelper {
    protected ProcessEngineRule engineRule;
    protected MigrationTestRule migrationRule;
    public ProcessDefinition sourceProcessDefinition;
    public ProcessDefinition targetProcessDefinition;

    public BatchMigrationHelper(ProcessEngineRule engineRule, MigrationTestRule migrationRule) {
        this.engineRule = engineRule;
        this.migrationRule = migrationRule;
    }

    public Batch migrateProcessInstancesAsync(int numberOfProcessInstances) {
        this.sourceProcessDefinition = this.migrationRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        this.targetProcessDefinition = this.migrationRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        ArrayList<String> processInstanceIds = new ArrayList<String>(numberOfProcessInstances);
        for (int i = 0; i < numberOfProcessInstances; ++i) {
            processInstanceIds.add(runtimeService.startProcessInstanceById(this.sourceProcessDefinition.getId()).getId());
        }
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(this.sourceProcessDefinition.getId(), this.targetProcessDefinition.getId()).mapEqualActivities().build();
        return runtimeService.newMigration(migrationPlan).processInstanceIds(processInstanceIds).executeAsync();
    }

    public Job getJobForDefinition(JobDefinition jobDefinition) {
        if (jobDefinition != null) {
            return (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        }
        return null;
    }

    public List<Job> getJobsForDefinition(JobDefinition jobDefinition) {
        return this.engineRule.getManagementService().createJobQuery().jobDefinitionId(jobDefinition.getId()).list();
    }

    public void executeJob(Job job) {
        Assert.assertNotNull((String)"Job to execute does not exist", (Object)job);
        try {
            this.engineRule.getManagementService().executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JobDefinition getSeedJobDefinition(Batch batch) {
        return (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).jobType("batch-seed-job").singleResult();
    }

    public Job getSeedJob(Batch batch) {
        return this.getJobForDefinition(this.getSeedJobDefinition(batch));
    }

    public void executeSeedJob(Batch batch) {
        this.executeJob(this.getSeedJob(batch));
    }

    public JobDefinition getMonitorJobDefinition(Batch batch) {
        return (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).jobType("batch-monitor-job").singleResult();
    }

    public Job getMonitorJob(Batch batch) {
        return this.getJobForDefinition(this.getMonitorJobDefinition(batch));
    }

    public void executeMonitorJob(Batch batch) {
        this.executeJob(this.getMonitorJob(batch));
    }

    public JobDefinition getMigrationJobDefinition(Batch batch) {
        return (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).jobType("instance-migration").singleResult();
    }

    public List<Job> getMigrationJobs(Batch batch) {
        return this.getJobsForDefinition(this.getMigrationJobDefinition(batch));
    }

    public void executeMigrationJobs(Batch batch) {
        for (Job migrationJob : this.getMigrationJobs(batch)) {
            this.executeJob(migrationJob);
        }
    }

    public HistoricBatch getHistoricBatch(Batch batch) {
        return (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().batchId(batch.getId()).singleResult();
    }

    public List<HistoricJobLog> getHistoricSeedJobLog(Batch batch) {
        return ((HistoricJobLogQuery)this.engineRule.getHistoryService().createHistoricJobLogQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).orderPartiallyByOccurrence().asc()).list();
    }

    public List<HistoricJobLog> getHistoricMonitorJobLog(Batch batch) {
        return ((HistoricJobLogQuery)this.engineRule.getHistoryService().createHistoricJobLogQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).orderPartiallyByOccurrence().asc()).list();
    }

    public List<HistoricJobLog> getHistoricBatchJobLog(Batch batch) {
        return ((HistoricJobLogQuery)this.engineRule.getHistoryService().createHistoricJobLogQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).orderPartiallyByOccurrence().asc()).list();
    }

    public long countSourceProcessInstances() {
        return this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(this.sourceProcessDefinition.getId()).count();
    }

    public long countTargetProcessInstances() {
        return this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(this.targetProcessDefinition.getId()).count();
    }

    public Date addSeconds(Date date, int seconds) {
        return new Date(date.getTime() + (long)(seconds * 1000));
    }

    public Date addSecondsToClock(int seconds) {
        Date newDate = this.addSeconds(ClockUtil.getCurrentTime(), seconds);
        ClockUtil.setCurrentTime((Date)newDate);
        return newDate;
    }
}

