/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.batch;

import java.util.Date;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchMigrationHistoryTest {
    protected static final Date START_DATE = new Date(1457326800000L);
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected ProcessDefinition sourceProcessDefinition;
    protected ProcessDefinition targetProcessDefinition;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)START_DATE);
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void removeBatches() {
        for (Batch batch : this.managementService.createBatchQuery().list()) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        for (HistoricBatch historicBatch : this.historyService.createHistoricBatchQuery().list()) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void testHistoricBatchCreation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)batch.getId(), (Object)historicBatch.getId());
        Assert.assertEquals((Object)batch.getType(), (Object)historicBatch.getType());
        Assert.assertEquals((long)batch.getSize(), (long)historicBatch.getSize());
        Assert.assertEquals((long)batch.getBatchJobsPerSeed(), (long)historicBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)batch.getInvocationsPerBatchJob(), (long)historicBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)historicBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)historicBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)historicBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)START_DATE, (Object)historicBatch.getStartTime());
        Assert.assertNull((Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricBatchCompletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        this.helper.executeMigrationJobs(batch);
        Date endDate = this.helper.addSecondsToClock(12);
        this.helper.executeMonitorJob(batch);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)endDate, (Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricSeedJobLog() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        HistoricJobLog jobLog = this.helper.getHistoricSeedJobLog(batch).get(0);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-seed-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertNull((Object)jobLog.getJobDueDate());
        Date executionDate = this.helper.addSecondsToClock(12);
        this.helper.executeSeedJob(batch);
        jobLog = this.helper.getHistoricSeedJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-seed-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertNull((Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricMonitorJobLog() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        HistoricJobLog jobLog = this.helper.getHistoricMonitorJobLog(batch).get(0);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-monitor-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertEquals((Object)this.helper.addSeconds(START_DATE, 30), (Object)jobLog.getJobDueDate());
        Date executionDate = this.helper.addSecondsToClock(15);
        this.helper.executeMigrationJobs(batch);
        this.helper.executeMonitorJob(batch);
        jobLog = this.helper.getHistoricMonitorJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-monitor-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertEquals((Object)this.helper.addSeconds(START_DATE, 30), (Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricBatchJobLog() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        Date executionDate = this.helper.addSecondsToClock(12);
        this.helper.executeMigrationJobs(batch);
        HistoricJobLog jobLog = this.helper.getHistoricBatchJobLog(batch).get(0);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"instance-migration", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertNull((Object)jobLog.getJobDueDate());
        jobLog = this.helper.getHistoricBatchJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"instance-migration", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertNull((Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricBatchForBatchDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.managementService.deleteBatch(batch.getId(), false);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)deletionDate, (Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricSeedJobLogForBatchDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.managementService.deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricSeedJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testHistoricMonitorJobLogForBatchDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.managementService.deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricMonitorJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testHistoricBatchJobLogForBatchDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.managementService.deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricBatchJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testDeleteHistoricBatch() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        this.helper.executeMigrationJobs(batch);
        this.helper.executeMonitorJob(batch);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        this.historyService.deleteHistoricBatch(historicBatch.getId());
        Assert.assertNull((Object)this.helper.getHistoricBatch(batch));
        Assert.assertTrue((boolean)this.helper.getHistoricSeedJobLog(batch).isEmpty());
        Assert.assertTrue((boolean)this.helper.getHistoricMonitorJobLog(batch).isEmpty());
        Assert.assertTrue((boolean)this.helper.getHistoricBatchJobLog(batch).isEmpty());
    }
}

