/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.batch;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchMigrationTest {
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected int defaultBatchJobsPerSeed;
    protected int defaultInvocationsPerBatchJob;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void removeBatches() {
        for (Batch batch : this.managementService.createBatchQuery().list()) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        for (HistoricBatch historicBatch : this.historyService.createHistoricBatchQuery().list()) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @Before
    public void storeEngineSettings() {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = configuration.getBatchJobsPerSeed();
        this.defaultInvocationsPerBatchJob = configuration.getInvocationsPerBatchJob();
    }

    @After
    public void restoreEngineSettings() {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        configuration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        configuration.setInvocationsPerBatchJob(this.defaultInvocationsPerBatchJob);
    }

    @Test
    public void testNullMigrationPlan() {
        try {
            this.runtimeService.newMigration(null).processInstanceIds(Collections.singletonList("process")).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"migration plan is null"));
        }
    }

    @Test
    public void testNullProcessInstanceIds() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(null).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is null"));
        }
    }

    @Test
    public void testEmptyProcessInstanceIds() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.emptyList()).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is empty"));
        }
    }

    @Test
    public void testBatchCreation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(15);
        Assert.assertNotNull((Object)batch);
        Assert.assertNotNull((Object)batch.getId());
        Assert.assertEquals((Object)"instance-migration", (Object)batch.getType());
        Assert.assertEquals((long)15L, (long)batch.getSize());
        Assert.assertEquals((long)10L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)1L, (long)batch.getInvocationsPerBatchJob());
    }

    @Test
    public void testSeedJobCreation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Assert.assertEquals((Object)batch.getId(), (Object)seedJobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)"batch-seed-job", (Object)seedJobDefinition.getJobType());
        JobDefinition migrationJobDefinition = this.helper.getMigrationJobDefinition(batch);
        Assert.assertNotNull((Object)migrationJobDefinition);
        Assert.assertEquals((Object)"instance-migration", (Object)migrationJobDefinition.getJobType());
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJob);
        Assert.assertEquals((Object)seedJobDefinition.getId(), (Object)seedJob.getJobDefinitionId());
        Assert.assertNull((Object)seedJob.getDuedate());
        Assert.assertNull((Object)seedJob.getDeploymentId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionKey());
        Assert.assertNull((Object)seedJob.getProcessInstanceId());
        Assert.assertNull((Object)seedJob.getExecutionId());
        List<Job> migrationJobs = this.helper.getMigrationJobs(batch);
        Assert.assertEquals((long)0L, (long)migrationJobs.size());
    }

    @Test
    public void testMigrationJobsCreation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(20);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        JobDefinition migrationJobDefinition = this.helper.getMigrationJobDefinition(batch);
        this.helper.executeSeedJob(batch);
        List<Job> migrationJobs = this.helper.getJobsForDefinition(migrationJobDefinition);
        Assert.assertEquals((long)10L, (long)migrationJobs.size());
        for (Job migrationJob : migrationJobs) {
            Assert.assertEquals((Object)migrationJobDefinition.getId(), (Object)migrationJob.getJobDefinitionId());
            Assert.assertNull((Object)migrationJob.getDuedate());
            Assert.assertNull((Object)migrationJob.getDeploymentId());
            Assert.assertNull((Object)migrationJob.getProcessDefinitionId());
            Assert.assertNull((Object)migrationJob.getProcessDefinitionKey());
            Assert.assertNull((Object)migrationJob.getProcessInstanceId());
            Assert.assertNull((Object)migrationJob.getExecutionId());
        }
        Job seedJob = this.helper.getJobForDefinition(seedJobDefinition);
        Assert.assertNotNull((Object)seedJob);
    }

    @Test
    public void testMonitorJobCreation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.executeSeedJob(batch);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNull((Object)seedJob);
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        Assert.assertNotNull((Object)monitorJobDefinition);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
    }

    @Test
    public void testMigrationJobsExecution() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.executeSeedJob(batch);
        List<Job> migrationJobs = this.helper.getMigrationJobs(batch);
        for (Job migrationJob : migrationJobs) {
            this.helper.executeJob(migrationJob);
        }
        Assert.assertEquals((long)0L, (long)this.helper.countSourceProcessInstances());
        Assert.assertEquals((long)10L, (long)this.helper.countTargetProcessInstances());
        Assert.assertEquals((long)0L, (long)this.helper.getMigrationJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void testNumberOfJobsCreatedBySeedJobPerInvocation() {
        int batchJobsPerSeed = ((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getBatchJobsPerSeed();
        Batch batch = this.helper.migrateProcessInstancesAsync(batchJobsPerSeed * 2 + 4);
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)batch.getBatchJobsPerSeed(), (long)this.helper.getMigrationJobs(batch).size());
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)(2 * batch.getBatchJobsPerSeed()), (long)this.helper.getMigrationJobs(batch).size());
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)(2 * batch.getBatchJobsPerSeed() + 4), (long)this.helper.getMigrationJobs(batch).size());
        Assert.assertNull((Object)this.helper.getSeedJob(batch));
    }

    @Test
    public void testCustomNumberOfJobsCreateBySeedJob() {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        configuration.setBatchJobsPerSeed(2);
        configuration.setInvocationsPerBatchJob(5);
        Batch batch = this.helper.migrateProcessInstancesAsync(20);
        Assert.assertEquals((long)2L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)5L, (long)batch.getInvocationsPerBatchJob());
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)2L, (long)this.helper.getMigrationJobs(batch).size());
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)4L, (long)this.helper.getMigrationJobs(batch).size());
        Assert.assertNull((Object)this.helper.getSeedJob(batch));
    }

    @Test
    public void testMonitorJobPollingForCompletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        Date createDate = new Date(1457326800000L);
        ClockUtil.setCurrentTime((Date)createDate);
        this.helper.executeSeedJob(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Date dueDate = this.helper.addSeconds(createDate, 30);
        Assert.assertEquals((Object)dueDate, (Object)monitorJob.getDuedate());
    }

    @Test
    public void testMonitorJobRemovesBatchAfterCompletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.executeSeedJob(batch);
        this.helper.executeMigrationJobs(batch);
        this.helper.executeMonitorJob(batch);
        Assert.assertEquals((long)0L, (long)this.managementService.createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Test
    public void testBatchDeletionWithCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.executeSeedJob(batch);
        this.managementService.deleteBatch(batch.getId(), true);
        Assert.assertEquals((long)0L, (long)this.managementService.createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Test
    public void testBatchDeletionWithoutCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.executeSeedJob(batch);
        this.managementService.deleteBatch(batch.getId(), false);
        Assert.assertEquals((long)0L, (long)this.managementService.createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Test
    public void testBatchExecutionFailureWithMissingProcessInstance() {
        Batch batch = this.helper.migrateProcessInstancesAsync(2);
        this.helper.executeSeedJob(batch);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String deletedProcessInstanceId = ((ProcessInstance)processInstances.get(0)).getId();
        this.runtimeService.deleteProcessInstance(deletedProcessInstanceId, "test");
        this.helper.executeMigrationJobs(batch);
        Assert.assertEquals((long)0L, (long)this.helper.countSourceProcessInstances());
        Assert.assertEquals((long)1L, (long)this.helper.countTargetProcessInstances());
        List<Job> migrationJobs = this.helper.getMigrationJobs(batch);
        Assert.assertEquals((long)1L, (long)migrationJobs.size());
        Job failedJob = migrationJobs.get(0);
        Assert.assertEquals((long)2L, (long)failedJob.getRetries());
        Assert.assertThat((Object)failedJob.getExceptionMessage(), (Matcher)CoreMatchers.startsWith((String)"ENGINE-23003"));
        Assert.assertThat((Object)failedJob.getExceptionMessage(), (Matcher)CoreMatchers.containsString((String)("Process instance '" + deletedProcessInstanceId + "' cannot be migrated")));
    }
}

