/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.history;

import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationHistoryVariablesTest {
    protected ProcessEngineRule rule = new ProcessEngineRule(true);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    protected static final BpmnModelInstance ONE_BOUNDARY_TASK = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent().message("Message")).done();
    protected static final BpmnModelInstance CONCURRENT_BOUNDARY_TASKS = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent().message("Message")).moveToActivity("userTask2").boundaryEvent().message("Message")).done();
    protected static final BpmnModelInstance SUBPROCESS_CONCURRENT_BOUNDARY_TASKS = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS).activityBuilder("userTask1").boundaryEvent().message("Message")).moveToActivity("userTask2").boundaryEvent().message("Message")).done();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
        this.historyService = this.rule.getHistoryService();
    }

    @Test
    public void noHistoryUpdateOnSameStructureMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ONE_BOUNDARY_TASK);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ONE_BOUNDARY_TASK);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree scopeExecution = executionTreeBeforeMigration.getExecutions().get(0);
        this.runtimeService.setVariableLocal(scopeExecution.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Test
    public void noHistoryUpdateOnAddScopeMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(CONCURRENT_BOUNDARY_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(SUBPROCESS_CONCURRENT_BOUNDARY_TASKS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0).getParent();
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
    }
}

