/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.compensate;

import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class CompensateEventHistoryTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventHistoryTest.testBoundaryCompensationHandlerHistory.bpmn20.xml"})
    public void testBoundaryCompensationHandlerHistoryActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("boundaryHandlerProcess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        String compensationHandlerActivityInstanceId = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("compensationHandler")[0].getId();
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(compensationHandler.getId());
        HistoricActivityInstance historicCompensationHandlerInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("compensationHandler").singleResult();
        CompensateEventHistoryTest.assertNotNull((Object)historicCompensationHandlerInstance);
        CompensateEventHistoryTest.assertEquals((String)compensationHandlerActivityInstanceId, (String)historicCompensationHandlerInstance.getId());
        CompensateEventHistoryTest.assertEquals((String)processInstance.getId(), (String)historicCompensationHandlerInstance.getParentActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventHistoryTest.testBoundaryCompensationHandlerHistory.bpmn20.xml"})
    public void FAILING_testBoundaryCompensationHandlerHistoryVariableInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("boundaryHandlerProcess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        String compensationHandlerActivityInstanceId = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("compensationHandler")[0].getId();
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariableLocal(compensationHandler.getExecutionId(), "apiVariable", (Object)"someValue");
        this.taskService.complete(compensationHandler.getId());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        CompensateEventHistoryTest.assertNotNull((Object)historicVariableInstance);
        CompensateEventHistoryTest.assertEquals((String)compensationHandlerActivityInstanceId, (String)historicVariableInstance.getActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventHistoryTest.testDefaultCompensationHandlerHistory.bpmn20.xml"})
    public void testDefaultCompensationHandlerHistoryActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("defaultHandlerProcess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        String compensationHandlerActivityInstanceId = tree.getActivityInstances("compensationHandler")[0].getId();
        String subProcessActivityInstanceId = tree.getActivityInstances("subProcess")[0].getId();
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(compensationHandler.getId());
        HistoricActivityInstance historicCompensationHandlerInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("compensationHandler").singleResult();
        CompensateEventHistoryTest.assertNotNull((Object)historicCompensationHandlerInstance);
        CompensateEventHistoryTest.assertEquals((String)compensationHandlerActivityInstanceId, (String)historicCompensationHandlerInstance.getId());
        CompensateEventHistoryTest.assertEquals((String)subProcessActivityInstanceId, (String)historicCompensationHandlerInstance.getParentActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventHistoryTest.testDefaultCompensationHandlerHistory.bpmn20.xml"})
    public void FAILING_testDefaultCompensationHandlerHistoryVariableInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("defaultHandlerProcess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        String compensationHandlerActivityInstanceId = tree.getActivityInstances("compensationHandler")[0].getId();
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariableLocal(compensationHandler.getExecutionId(), "apiVariable", (Object)"someValue");
        this.taskService.complete(compensationHandler.getId());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        CompensateEventHistoryTest.assertNotNull((Object)historicVariableInstance);
        CompensateEventHistoryTest.assertEquals((String)compensationHandlerActivityInstanceId, (String)historicVariableInstance.getActivityInstanceId());
    }
}

