/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JobExecutorShutdownTest {
    protected static final BpmnModelInstance TWO_ASYNC_TASKS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task1").camundaClass(SyncDelegate.class.getName())).camundaAsyncBefore()).camundaExclusive(true)).serviceTask("task2").camundaClass(SyncDelegate.class.getName())).camundaAsyncBefore()).camundaExclusive(true)).endEvent().done();
    protected static final BpmnModelInstance SINGLE_ASYNC_TASK = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task1").camundaClass(SyncDelegate.class.getName())).camundaAsyncBefore()).camundaExclusive(true)).endEvent().done();
    @Rule
    public ProcessEngineRule engineRule = new ProcessEngineRule(((ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml")).setJobExecutor((JobExecutor)JobExecutorShutdownTest.buildControllableJobExecutor()).buildProcessEngine());
    protected ControllableJobExecutor jobExecutor;
    protected ConcurrencyTestCase.ThreadControl acquisitionThread;
    protected static ConcurrencyTestCase.ThreadControl executionThread;

    protected static ControllableJobExecutor buildControllableJobExecutor() {
        ControllableJobExecutor jobExecutor = new ControllableJobExecutor();
        jobExecutor.setMaxJobsPerAcquisition(2);
        jobExecutor.proceeedAndWaitOnShutdown(false);
        return jobExecutor;
    }

    @Before
    public void setUp() throws Exception {
        this.jobExecutor = (ControllableJobExecutor)((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getJobExecutor();
        this.jobExecutor.setMaxJobsPerAcquisition(2);
        this.acquisitionThread = this.jobExecutor.getAcquisitionThreadControl();
        executionThread = this.jobExecutor.getExecutionThreadControl();
    }

    @Test
    public void testConcurrentShutdownAndExclusiveFollowUpJob() {
        Deployment deployment = this.engineRule.getRepositoryService().createDeployment().addModelInstance("foo.bpmn", TWO_ASYNC_TASKS).deploy();
        this.engineRule.manageDeployment(deployment);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Job firstAsyncJob = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.ignoreFutureSyncs();
        this.acquisitionThread.makeContinue();
        executionThread.waitForSync();
        this.jobExecutor.shutdown();
        executionThread.waitUntilDone();
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createJobQuery().jobId(firstAsyncJob.getId()).count());
        JobEntity secondAsyncJob = (JobEntity)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)secondAsyncJob);
        Assert.assertFalse((boolean)secondAsyncJob.getId().equals(firstAsyncJob.getId()));
        Assert.assertNull((Object)secondAsyncJob.getLockOwner());
        Assert.assertNull((Object)secondAsyncJob.getLockExpirationTime());
    }

    @Test
    public void testShutdownAndMultipleLockedJobs() {
        Deployment deployment = this.engineRule.getRepositoryService().createDeployment().addModelInstance("foo.bpmn", SINGLE_ASYNC_TASK).deploy();
        this.engineRule.manageDeployment(deployment);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.ignoreFutureSyncs();
        this.acquisitionThread.makeContinue();
        executionThread.waitForSync();
        List lockedJobList = this.engineRule.getManagementService().createJobQuery().list();
        Assert.assertEquals((long)2L, (long)lockedJobList.size());
        for (Job job : lockedJobList) {
            JobEntity jobEntity = (JobEntity)job;
            Assert.assertNotNull((Object)jobEntity.getLockOwner());
        }
        this.jobExecutor.shutdown();
        executionThread.waitUntilDone();
        JobEntity jobEntity = (JobEntity)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)jobEntity);
        Assert.assertTrue((((Job)lockedJobList.get(1)).getId().equals(jobEntity.getId()) || ((Job)lockedJobList.get(0)).getId().equals(jobEntity.getId()) ? 1 : 0) != 0);
        Assert.assertNull((Object)jobEntity.getLockOwner());
        Assert.assertNull((Object)jobEntity.getLockExpirationTime());
    }

    public static class SyncDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            executionThread.sync();
        }
    }
}

