/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class BatchMonitorJobHandler
implements JobHandler {
    public static final String TYPE = "batch-monitor-job";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(String batchId, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        BatchEntity batch = commandContext.getBatchManager().findBatchById(batchId);
        EnsureUtil.ensureNotNull("Batch with id '" + batchId + "' cannot be found", "batch", (Object)batch);
        boolean completed = batch.isCompleted();
        if (!completed) {
            batch.createMonitorJob();
        } else {
            batch.delete(false);
        }
    }
}

