/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import java.util.List;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.BatchQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.BatchQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class BatchQueryImpl
extends AbstractQuery<BatchQuery, Batch>
implements BatchQuery {
    private static final long serialVersionUID = 1L;
    protected String batchId;
    protected String type;

    public BatchQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public BatchQuery batchId(String batchId) {
        EnsureUtil.ensureNotNull("Batch id", (Object)batchId);
        this.batchId = batchId;
        return this;
    }

    public String getBatchId() {
        return this.batchId;
    }

    @Override
    public BatchQuery type(String type) {
        EnsureUtil.ensureNotNull("Type", (Object)type);
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public BatchQuery orderById() {
        return (BatchQuery)this.orderBy(BatchQueryProperty.ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getBatchManager().findBatchCountByQueryCriteria(this);
    }

    @Override
    public List<Batch> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getBatchManager().findBatchesByQueryCriteria(this, page);
    }
}

