/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteBatchCmd
implements Command<Void> {
    protected boolean cascadeToHistory;
    protected String batchId;

    public DeleteBatchCmd(String batchId, boolean cascadeToHistory) {
        this.batchId = batchId;
        this.cascadeToHistory = cascadeToHistory;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Batch id must not be null", "batch id", (Object)this.batchId);
        BatchEntity batchEntity = commandContext.getBatchManager().findBatchById(this.batchId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Batch for id '" + this.batchId + "' cannot be found", "batch", (Object)batchEntity);
        batchEntity.delete(this.cascadeToHistory);
        return null;
    }
}

