/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;

public class CompensationUtil {
    public static final String SIGNAL_COMPENSATION_DONE = "compensationDone";

    public static void throwCompensationEvent(List<CompensateEventSubscriptionEntity> eventSubscriptions, ActivityExecution execution, boolean async) {
        for (CompensateEventSubscriptionEntity eventSubscription : eventSubscriptions) {
            ExecutionEntity compensatingExecution = null;
            if (eventSubscription.getConfiguration() != null) {
                compensatingExecution = Context.getCommandContext().getExecutionManager().findExecutionById(eventSubscription.getConfiguration());
                if (compensatingExecution.getParent() != execution) {
                    compensatingExecution.setParent((PvmExecutionImpl)execution);
                }
                compensatingExecution.setEventScope(false);
            } else {
                compensatingExecution = (ExecutionEntity)execution.createExecution();
                eventSubscription.setConfiguration(compensatingExecution.getId());
            }
            compensatingExecution.setConcurrent(true);
        }
        Collections.sort(eventSubscriptions, new Comparator<EventSubscriptionEntity>(){

            @Override
            public int compare(EventSubscriptionEntity o1, EventSubscriptionEntity o2) {
                return o1.getCreated().compareTo(o2.getCreated());
            }
        });
        for (CompensateEventSubscriptionEntity compensateEventSubscriptionEntity : eventSubscriptions) {
            compensateEventSubscriptionEntity.eventReceived(null, async);
        }
    }

    public static void createEventScopeExecution(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        ExecutionEntity scopeExecution = (ExecutionEntity)execution.findExecutionForFlowScope(activity.getFlowScope());
        List<CompensateEventSubscriptionEntity> eventSubscriptions = execution.getCompensateEventSubscriptions();
        if (eventSubscriptions.size() > 0 || CompensationUtil.hasCompensationEventSubprocess(activity)) {
            ExecutionEntity eventScopeExecution = scopeExecution.createExecution();
            eventScopeExecution.setActivity(execution.getActivity());
            eventScopeExecution.enterActivityInstance();
            eventScopeExecution.setActive(false);
            eventScopeExecution.setConcurrent(false);
            eventScopeExecution.setEventScope(true);
            VariableMapImpl variables = execution.getVariablesLocal();
            for (Map.Entry entry : variables.entrySet()) {
                eventScopeExecution.setVariableLocal((String)entry.getKey(), entry.getValue());
            }
            for (CompensateEventSubscriptionEntity compensateEventSubscriptionEntity : eventSubscriptions) {
                CompensateEventSubscriptionEntity compensateEventSubscriptionEntity2 = compensateEventSubscriptionEntity.moveUnder(eventScopeExecution);
            }
            for (PvmExecutionImpl pvmExecutionImpl : execution.getEventScopeExecutions()) {
                pvmExecutionImpl.setParent(eventScopeExecution);
            }
            ActivityImpl compensationHandler = CompensationUtil.getEventScopeCompensationHandler(execution);
            CompensateEventSubscriptionEntity compensateEventSubscriptionEntity = CompensateEventSubscriptionEntity.createAndInsert(scopeExecution, compensationHandler);
            compensateEventSubscriptionEntity.setConfiguration(eventScopeExecution.getId());
        }
    }

    protected static boolean hasCompensationEventSubprocess(ActivityImpl activity) {
        ActivityImpl compensationHandler = activity.findCompensationHandler();
        return compensationHandler != null && compensationHandler.isSubProcessScope() && compensationHandler.isTriggeredByEvent();
    }

    protected static ActivityImpl getEventScopeCompensationHandler(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        ActivityImpl compensationHandler = activity.findCompensationHandler();
        if (compensationHandler != null && compensationHandler.isSubProcessScope()) {
            return compensationHandler;
        }
        return activity;
    }

    public static List<CompensateEventSubscriptionEntity> collectCompensateEventSubscriptionsForScope(ActivityExecution execution) {
        final Map<ScopeImpl, PvmExecutionImpl> scopeExecutionMapping = execution.createActivityExecutionMapping();
        ScopeImpl activity = (ScopeImpl)((Object)execution.getActivity());
        final HashSet subscriptions = new HashSet();
        TreeVisitor<ScopeImpl> eventSubscriptionCollector = new TreeVisitor<ScopeImpl>(){

            @Override
            public void visit(ScopeImpl obj) {
                PvmExecutionImpl execution = (PvmExecutionImpl)scopeExecutionMapping.get(obj);
                subscriptions.addAll(((ExecutionEntity)execution).getCompensateEventSubscriptions());
            }
        };
        new FlowScopeWalker(activity).addPostVisitor(eventSubscriptionCollector).walkUntil(new ReferenceWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                Boolean consumesCompensationProperty = (Boolean)element.getProperty("consumesCompensation");
                return consumesCompensationProperty == null || consumesCompensationProperty == Boolean.TRUE;
            }
        });
        return new ArrayList<CompensateEventSubscriptionEntity>(subscriptions);
    }

    public static List<CompensateEventSubscriptionEntity> collectCompensateEventSubscriptionsForActivity(ActivityExecution execution, String activityRef) {
        List<CompensateEventSubscriptionEntity> eventSubscriptions = CompensationUtil.collectCompensateEventSubscriptionsForScope(execution);
        String subscriptionActivityId = CompensationUtil.getSubscriptionActivityId(execution, activityRef);
        ArrayList<CompensateEventSubscriptionEntity> eventSubscriptionsForActivity = new ArrayList<CompensateEventSubscriptionEntity>();
        for (CompensateEventSubscriptionEntity subscription : eventSubscriptions) {
            if (!subscriptionActivityId.equals(subscription.getActivityId())) continue;
            eventSubscriptionsForActivity.add(subscription);
        }
        return eventSubscriptionsForActivity;
    }

    private static String getSubscriptionActivityId(ActivityExecution execution, String activityRef) {
        ActivityImpl activityToCompensate = ((ExecutionEntity)execution).getProcessDefinition().findActivity(activityRef);
        if (activityToCompensate.isMultiInstance()) {
            ActivityImpl flowScope = (ActivityImpl)activityToCompensate.getFlowScope();
            return flowScope.getActivityId();
        }
        ActivityImpl compensationHandler = activityToCompensate.findCompensationHandler();
        if (compensationHandler != null) {
            return compensationHandler.getActivityId();
        }
        return activityRef;
    }
}

