/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.ActivityExecutionTreeMapping;
import org.camunda.bpm.engine.impl.bpmn.behavior.SequentialMultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.camunda.bpm.engine.impl.core.delegate.CoreActivityBehavior;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.tree.ActivityStackCollector;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;

public abstract class AbstractInstantiationCmd
extends AbstractProcessInstanceModificationCommand {
    protected VariableMap variables;
    protected VariableMap variablesLocal;
    protected String ancestorActivityInstanceId;

    public AbstractInstantiationCmd(String processInstanceId, String ancestorActivityInstanceId) {
        super(processInstanceId);
        this.ancestorActivityInstanceId = ancestorActivityInstanceId;
        this.variables = new VariableMapImpl();
        this.variablesLocal = new VariableMapImpl();
    }

    public void addVariable(String name, Object value) {
        this.variables.put((Object)name, value);
    }

    public void addVariableLocal(String name, Object value) {
        this.variablesLocal.put((Object)name, value);
    }

    public void addVariables(Map<String, Object> variables) {
        this.variables.putAll(variables);
    }

    public void addVariablesLocal(Map<String, Object> variables) {
        this.variablesLocal.putAll(variables);
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public VariableMap getVariablesLocal() {
        return this.variablesLocal;
    }

    @Override
    public Void execute(final CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        final ProcessDefinitionImpl processDefinition = processInstance.getProcessDefinition();
        CoreModelElement elementToInstantiate = this.getTargetElement(processDefinition);
        EnsureUtil.ensureNotNull(NotValidException.class, this.describeFailure("Element '" + this.getTargetElementId() + "' does not exist in process '" + processDefinition.getId() + "'"), "element", (Object)elementToInstantiate);
        final ActivityExecutionTreeMapping mapping = new ActivityExecutionTreeMapping(commandContext, this.processInstanceId);
        ScopeImpl targetFlowScope = this.getTargetFlowScope(processDefinition);
        ActivityStackCollector stackCollector = new ActivityStackCollector();
        FlowScopeWalker walker = new FlowScopeWalker(targetFlowScope);
        walker.addPreVisitor(stackCollector);
        ExecutionEntity scopeExecution = null;
        if (this.ancestorActivityInstanceId == null) {
            walker.walkWhile(new ReferenceWalker.WalkCondition<ScopeImpl>(){

                @Override
                public boolean isFulfilled(ScopeImpl element) {
                    return !mapping.getExecutions(element).isEmpty() || element == processDefinition;
                }
            });
            Set<ExecutionEntity> flowScopeExecutions = mapping.getExecutions((ScopeImpl)walker.getCurrentElement());
            if (flowScopeExecutions.size() > 1) {
                throw new ProcessEngineException("Ancestor activity execution is ambiguous for activity " + targetFlowScope);
            }
            scopeExecution = flowScopeExecutions.iterator().next();
        } else {
            ActivityInstance tree = commandContext.runWithoutAuthorization(new Callable<ActivityInstance>(){

                @Override
                public ActivityInstance call() throws Exception {
                    return new GetActivityInstanceCmd(AbstractInstantiationCmd.this.processInstanceId).execute(commandContext);
                }
            });
            ActivityInstance ancestorInstance = this.findActivityInstance(tree, this.ancestorActivityInstanceId);
            EnsureUtil.ensureNotNull(NotValidException.class, this.describeFailure("Ancestor activity instance '" + this.ancestorActivityInstanceId + "' does not exist"), "ancestorInstance", (Object)ancestorInstance);
            final ExecutionEntity ancestorScopeExecution = this.getScopeExecutionForActivityInstance(processInstance, mapping, ancestorInstance);
            final ScopeImpl ancestorScope = this.getScopeForActivityInstance(processDefinition, ancestorInstance);
            walker.walkWhile(new ReferenceWalker.WalkCondition<ScopeImpl>(){

                @Override
                public boolean isFulfilled(ScopeImpl element) {
                    return mapping.getExecutions(element).contains(ancestorScopeExecution) && element == ancestorScope || element == processDefinition;
                }
            });
            Set<ExecutionEntity> flowScopeExecutions = mapping.getExecutions((ScopeImpl)walker.getCurrentElement());
            if (!flowScopeExecutions.contains(ancestorScopeExecution)) {
                throw new NotValidException(this.describeFailure("Scope execution for '" + this.ancestorActivityInstanceId + "' cannot be found in parent hierarchy of flow element '" + elementToInstantiate.getId() + "'"));
            }
            scopeExecution = ancestorScopeExecution;
        }
        List<PvmActivity> activitiesToInstantiate = stackCollector.getActivityStack();
        Collections.reverse(activitiesToInstantiate);
        ActivityImpl topMostActivity = null;
        ScopeImpl flowScope = null;
        if (!activitiesToInstantiate.isEmpty()) {
            topMostActivity = (ActivityImpl)activitiesToInstantiate.get(0);
            flowScope = topMostActivity.getFlowScope();
        } else if (ActivityImpl.class.isAssignableFrom(elementToInstantiate.getClass())) {
            topMostActivity = (ActivityImpl)elementToInstantiate;
            flowScope = topMostActivity.getFlowScope();
        } else if (TransitionImpl.class.isAssignableFrom(elementToInstantiate.getClass())) {
            TransitionImpl transitionToInstantiate = (TransitionImpl)elementToInstantiate;
            flowScope = transitionToInstantiate.getSource().getFlowScope();
        }
        if (!this.supportsConcurrentChildInstantiation(flowScope)) {
            throw new ProcessEngineException("Concurrent instantiation not possible for activities in scope " + flowScope.getId());
        }
        ActivityStartBehavior startBehavior = ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE;
        if (topMostActivity != null) {
            startBehavior = topMostActivity.getActivityStartBehavior();
            if (!activitiesToInstantiate.isEmpty()) {
                PvmActivity initialActivity = (PvmActivity)topMostActivity.getProperty("initial");
                PvmActivity secondTopMostActivity = null;
                if (activitiesToInstantiate.size() > 1) {
                    secondTopMostActivity = activitiesToInstantiate.get(1);
                } else if (ActivityImpl.class.isAssignableFrom(elementToInstantiate.getClass())) {
                    secondTopMostActivity = (PvmActivity)((Object)elementToInstantiate);
                }
                if (initialActivity != secondTopMostActivity) {
                    startBehavior = ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE;
                }
            }
        }
        switch (startBehavior) {
            case CANCEL_EVENT_SCOPE: {
                ScopeImpl scopeToCancel = topMostActivity.getEventScope();
                ExecutionEntity executionToCancel = this.getSingleExecutionForScope(mapping, scopeToCancel);
                if (executionToCancel != null) {
                    executionToCancel.deleteCascade("Cancelling activity " + topMostActivity + " executed.", this.skipCustomListeners, this.skipIoMappings);
                    this.instantiate(executionToCancel.getParent(), activitiesToInstantiate, elementToInstantiate);
                    break;
                }
                ExecutionEntity flowScopeExecution = this.getSingleExecutionForScope(mapping, topMostActivity.getFlowScope());
                this.instantiateConcurrent(flowScopeExecution, activitiesToInstantiate, elementToInstantiate);
                break;
            }
            case INTERRUPT_EVENT_SCOPE: {
                ScopeImpl scopeToCancel = topMostActivity.getEventScope();
                ExecutionEntity executionToCancel = this.getSingleExecutionForScope(mapping, scopeToCancel);
                executionToCancel.interrupt("Interrupting activity " + topMostActivity + " executed.", this.skipCustomListeners, this.skipIoMappings);
                executionToCancel.setActivity(null);
                executionToCancel.leaveActivityInstance();
                this.instantiate(executionToCancel, activitiesToInstantiate, elementToInstantiate);
                break;
            }
            case INTERRUPT_FLOW_SCOPE: {
                ScopeImpl scopeToCancel = topMostActivity.getFlowScope();
                ExecutionEntity executionToCancel = this.getSingleExecutionForScope(mapping, scopeToCancel);
                executionToCancel.interrupt("Interrupting activity " + topMostActivity + " executed.", this.skipCustomListeners, this.skipIoMappings);
                executionToCancel.setActivity(null);
                executionToCancel.leaveActivityInstance();
                this.instantiate(executionToCancel, activitiesToInstantiate, elementToInstantiate);
                break;
            }
            default: {
                if (!scopeExecution.hasChildren() && (scopeExecution.getActivity() == null || scopeExecution.isEnded())) {
                    this.instantiate(scopeExecution, activitiesToInstantiate, elementToInstantiate);
                    break;
                }
                this.instantiateConcurrent(scopeExecution, activitiesToInstantiate, elementToInstantiate);
            }
        }
        return null;
    }

    protected boolean supportsConcurrentChildInstantiation(ScopeImpl flowScope) {
        CoreActivityBehavior<? extends BaseDelegateExecution> behavior = flowScope.getActivityBehavior();
        return behavior == null || !(behavior instanceof SequentialMultiInstanceActivityBehavior);
    }

    protected ExecutionEntity getSingleExecutionForScope(ActivityExecutionTreeMapping mapping, ScopeImpl scope) {
        Set<ExecutionEntity> executions = mapping.getExecutions(scope);
        if (!executions.isEmpty()) {
            if (executions.size() > 1) {
                throw new ProcessEngineException("Executions for activity " + scope + " ambiguous");
            }
            return executions.iterator().next();
        }
        return null;
    }

    protected boolean isConcurrentStart(ActivityStartBehavior startBehavior) {
        return startBehavior == ActivityStartBehavior.DEFAULT || startBehavior == ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE;
    }

    protected void instantiate(ExecutionEntity ancestorScopeExecution, List<PvmActivity> parentFlowScopes, CoreModelElement targetElement) {
        if (PvmTransition.class.isAssignableFrom(targetElement.getClass())) {
            ancestorScopeExecution.executeActivities(parentFlowScopes, null, (PvmTransition)((Object)targetElement), (Map<String, Object>)this.variables, (Map<String, Object>)this.variablesLocal, this.skipCustomListeners, this.skipIoMappings);
        } else if (PvmActivity.class.isAssignableFrom(targetElement.getClass())) {
            ancestorScopeExecution.executeActivities(parentFlowScopes, (PvmActivity)((Object)targetElement), null, (Map<String, Object>)this.variables, (Map<String, Object>)this.variablesLocal, this.skipCustomListeners, this.skipIoMappings);
        } else {
            throw new ProcessEngineException("Cannot instantiate element " + targetElement);
        }
    }

    protected void instantiateConcurrent(ExecutionEntity ancestorScopeExecution, List<PvmActivity> parentFlowScopes, CoreModelElement targetElement) {
        if (PvmTransition.class.isAssignableFrom(targetElement.getClass())) {
            ancestorScopeExecution.executeActivitiesConcurrent(parentFlowScopes, null, (PvmTransition)((Object)targetElement), (Map<String, Object>)this.variables, (Map<String, Object>)this.variablesLocal, this.skipCustomListeners, this.skipIoMappings);
        } else if (PvmActivity.class.isAssignableFrom(targetElement.getClass())) {
            ancestorScopeExecution.executeActivitiesConcurrent(parentFlowScopes, (PvmActivity)((Object)targetElement), null, (Map<String, Object>)this.variables, (Map<String, Object>)this.variablesLocal, this.skipCustomListeners, this.skipIoMappings);
        } else {
            throw new ProcessEngineException("Cannot instantiate element " + targetElement);
        }
    }

    protected abstract ScopeImpl getTargetFlowScope(ProcessDefinitionImpl var1);

    protected abstract CoreModelElement getTargetElement(ProcessDefinitionImpl var1);

    protected abstract String getTargetElementId();
}

