/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerChangeJobDefinitionSuspensionStateJobHandler;
import org.camunda.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.management.UpdateJobSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;

public abstract class AbstractSetJobDefinitionStateCmd
extends AbstractSetStateCmd {
    protected String jobDefinitionId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected Date executionDate;
    protected String processDefinitionTenantId;
    protected boolean isProcessDefinitionTenantIdSet = false;

    public AbstractSetJobDefinitionStateCmd(UpdateJobDefinitionSuspensionStateBuilderImpl builder) {
        super(builder.isIncludeJobs(), builder.getExecutionDate());
        this.jobDefinitionId = builder.getJobDefinitionId();
        this.processDefinitionId = builder.getProcessDefinitionId();
        this.processDefinitionKey = builder.getProcessDefinitionKey();
        this.isProcessDefinitionTenantIdSet = builder.isProcessDefinitionTenantIdSet();
        this.processDefinitionTenantId = builder.getProcessDefinitionTenantId();
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.jobDefinitionId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Job definition id, process definition id nor process definition key cannot be null");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.jobDefinitionId != null) {
            JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
            JobDefinitionEntity jobDefinition = jobDefinitionManager.findById(this.jobDefinitionId);
            if (jobDefinition != null) {
                String processDefinitionKey = jobDefinition.getProcessDefinitionKey();
                authorizationManager.checkUpdateProcessDefinitionByKey(processDefinitionKey);
                if (this.includeSubResources) {
                    authorizationManager.checkUpdateProcessInstanceByProcessDefinitionKey(processDefinitionKey);
                }
            }
        } else if (this.processDefinitionId != null) {
            authorizationManager.checkUpdateProcessDefinitionById(this.processDefinitionId);
            if (this.includeSubResources) {
                authorizationManager.checkUpdateProcessInstanceByProcessDefinitionId(this.processDefinitionId);
            }
        } else if (this.processDefinitionKey != null) {
            authorizationManager.checkUpdateProcessDefinitionByKey(this.processDefinitionKey);
            if (this.includeSubResources) {
                authorizationManager.checkUpdateProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
            }
        }
    }

    @Override
    protected void updateSuspensionState(CommandContext commandContext, SuspensionState suspensionState) {
        JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
        JobManager jobManager = commandContext.getJobManager();
        if (this.jobDefinitionId != null) {
            jobDefinitionManager.updateJobDefinitionSuspensionStateById(this.jobDefinitionId, suspensionState);
        } else if (this.processDefinitionId != null) {
            jobDefinitionManager.updateJobDefinitionSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            jobManager.updateStartTimerJobSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            if (!this.isProcessDefinitionTenantIdSet) {
                jobDefinitionManager.updateJobDefinitionSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
                jobManager.updateStartTimerJobSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            } else {
                jobDefinitionManager.updateJobDefinitionSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
                jobManager.updateStartTimerJobSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
            }
        }
    }

    @Override
    protected String getJobHandlerConfiguration() {
        String jobConfiguration = null;
        if (this.jobDefinitionId != null) {
            jobConfiguration = TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByJobDefinitionId(this.jobDefinitionId, this.isIncludeSubResources());
        } else if (this.processDefinitionId != null) {
            jobConfiguration = TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionId(this.processDefinitionId, this.isIncludeSubResources());
        } else if (this.processDefinitionKey != null) {
            jobConfiguration = !this.isProcessDefinitionTenantIdSet ? TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionKey(this.processDefinitionKey, this.isIncludeSubResources()) : TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, this.isIncludeSubResources());
        }
        return jobConfiguration;
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logJobDefinitionOperation(this.getLogEntryOperation(), this.jobDefinitionId, this.processDefinitionId, this.processDefinitionKey, propertyChange);
    }

    protected UpdateJobSuspensionStateBuilderImpl createJobCommandBuilder() {
        UpdateJobSuspensionStateBuilderImpl builder = new UpdateJobSuspensionStateBuilderImpl();
        if (this.jobDefinitionId != null) {
            builder.byJobDefinitionId(this.jobDefinitionId);
        } else if (this.processDefinitionId != null) {
            builder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            builder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.isProcessDefinitionTenantIdSet && this.processDefinitionTenantId != null) {
                builder.processDefinitionTenantId(this.processDefinitionTenantId);
            } else if (this.isProcessDefinitionTenantIdSet) {
                builder.processDefinitionWithoutTenantId();
            }
        }
        return builder;
    }

    @Override
    protected abstract String getDelayedExecutionJobHandlerType();

    @Override
    protected AbstractSetStateCmd getNextCommand() {
        UpdateJobSuspensionStateBuilderImpl jobCommandBuilder = this.createJobCommandBuilder();
        return this.getNextCommand(jobCommandBuilder);
    }

    protected abstract AbstractSetJobStateCmd getNextCommand(UpdateJobSuspensionStateBuilderImpl var1);
}

