/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerChangeProcessDefinitionSuspensionStateJobHandler;
import org.camunda.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.repository.UpdateProcessDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.runtime.UpdateProcessInstanceSuspensionStateBuilderImpl;

public abstract class AbstractSetProcessDefinitionStateCmd
extends AbstractSetStateCmd {
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String tenantId;
    protected boolean isTenantIdSet = false;

    public AbstractSetProcessDefinitionStateCmd(UpdateProcessDefinitionSuspensionStateBuilderImpl builder) {
        super(builder.isIncludeProcessInstances(), builder.getExecutionDate());
        this.processDefinitionId = builder.getProcessDefinitionId();
        this.processDefinitionKey = builder.getProcessDefinitionKey();
        this.isTenantIdSet = builder.isTenantIdSet();
        this.tenantId = builder.getProcessDefinitionTenantId();
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Process definition id / key cannot be null");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.processDefinitionId != null) {
            authorizationManager.checkUpdateProcessDefinitionById(this.processDefinitionId);
            if (this.includeSubResources) {
                authorizationManager.checkUpdateProcessInstanceByProcessDefinitionId(this.processDefinitionId);
            }
        } else if (this.processDefinitionKey != null) {
            authorizationManager.checkUpdateProcessDefinitionByKey(this.processDefinitionKey);
            if (this.includeSubResources) {
                authorizationManager.checkUpdateProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
            }
        }
    }

    @Override
    protected void updateSuspensionState(final CommandContext commandContext, SuspensionState suspensionState) {
        ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
        if (this.processDefinitionId != null) {
            processDefinitionManager.updateProcessDefinitionSuspensionStateById(this.processDefinitionId, suspensionState);
        } else if (this.isTenantIdSet) {
            processDefinitionManager.updateProcessDefinitionSuspensionStateByKeyAndTenantId(this.processDefinitionKey, this.tenantId, suspensionState);
        } else {
            processDefinitionManager.updateProcessDefinitionSuspensionStateByKey(this.processDefinitionKey, suspensionState);
        }
        commandContext.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                UpdateJobDefinitionSuspensionStateBuilderImpl jobDefinitionSuspensionStateBuilder = AbstractSetProcessDefinitionStateCmd.this.createJobDefinitionCommandBuilder();
                AbstractSetJobDefinitionStateCmd jobDefinitionCmd = AbstractSetProcessDefinitionStateCmd.this.getSetJobDefinitionStateCmd(jobDefinitionSuspensionStateBuilder);
                jobDefinitionCmd.disableLogUserOperation();
                jobDefinitionCmd.execute(commandContext);
                return null;
            }
        });
    }

    protected UpdateJobDefinitionSuspensionStateBuilderImpl createJobDefinitionCommandBuilder() {
        UpdateJobDefinitionSuspensionStateBuilderImpl jobDefinitionBuilder = new UpdateJobDefinitionSuspensionStateBuilderImpl();
        if (this.processDefinitionId != null) {
            jobDefinitionBuilder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            jobDefinitionBuilder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.isTenantIdSet && this.tenantId != null) {
                jobDefinitionBuilder.processDefinitionTenantId(this.tenantId);
            } else if (this.isTenantIdSet) {
                jobDefinitionBuilder.processDefinitionWithoutTenantId();
            }
        }
        return jobDefinitionBuilder;
    }

    protected UpdateProcessInstanceSuspensionStateBuilderImpl createProcessInstanceCommandBuilder() {
        UpdateProcessInstanceSuspensionStateBuilderImpl processInstanceBuilder = new UpdateProcessInstanceSuspensionStateBuilderImpl();
        if (this.processDefinitionId != null) {
            processInstanceBuilder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            processInstanceBuilder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.isTenantIdSet && this.tenantId != null) {
                processInstanceBuilder.processDefinitionTenantId(this.tenantId);
            } else if (this.isTenantIdSet) {
                processInstanceBuilder.processDefinitionWithoutTenantId();
            }
        }
        return processInstanceBuilder;
    }

    @Override
    protected String getJobHandlerConfiguration() {
        String jobConfiguration = null;
        jobConfiguration = this.processDefinitionId != null ? TimerChangeProcessDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionId(this.processDefinitionId, this.isIncludeSubResources()) : (this.isTenantIdSet ? TimerChangeProcessDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.tenantId, this.isIncludeSubResources()) : TimerChangeProcessDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionKey(this.processDefinitionKey, this.isIncludeSubResources()));
        return jobConfiguration;
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logProcessDefinitionOperation(this.getLogEntryOperation(), this.processDefinitionId, this.processDefinitionKey, propertyChange);
    }

    @Override
    protected abstract String getDelayedExecutionJobHandlerType();

    protected abstract AbstractSetJobDefinitionStateCmd getSetJobDefinitionStateCmd(UpdateJobDefinitionSuspensionStateBuilderImpl var1);

    @Override
    protected AbstractSetProcessInstanceStateCmd getNextCommand() {
        UpdateProcessInstanceSuspensionStateBuilderImpl processInstanceCommandBuilder = this.createProcessInstanceCommandBuilder();
        return this.getNextCommand(processInstanceCommandBuilder);
    }

    protected abstract AbstractSetProcessInstanceStateCmd getNextCommand(UpdateProcessInstanceSuspensionStateBuilderImpl var1);
}

