/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.management.UpdateJobSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.runtime.UpdateProcessInstanceSuspensionStateBuilderImpl;

public abstract class AbstractSetProcessInstanceStateCmd
extends AbstractSetStateCmd {
    protected final String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionTenantId;
    protected boolean isProcessDefinitionTenantIdSet = false;

    public AbstractSetProcessInstanceStateCmd(UpdateProcessInstanceSuspensionStateBuilderImpl builder) {
        super(true, null);
        this.processInstanceId = builder.getProcessInstanceId();
        this.processDefinitionId = builder.getProcessDefinitionId();
        this.processDefinitionKey = builder.getProcessDefinitionKey();
        this.processDefinitionTenantId = builder.getProcessDefinitionTenantId();
        this.isProcessDefinitionTenantIdSet = builder.isProcessDefinitionTenantIdSet();
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.processInstanceId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("ProcessInstanceId, ProcessDefinitionId nor ProcessDefinitionKey cannot be null.");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.processInstanceId != null) {
            authorizationManager.checkUpdateProcessInstanceById(this.processInstanceId);
        } else if (this.processDefinitionId != null) {
            authorizationManager.checkUpdateProcessInstanceByProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            authorizationManager.checkUpdateProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
        }
    }

    @Override
    protected void updateSuspensionState(CommandContext commandContext, SuspensionState suspensionState) {
        ExecutionManager executionManager = commandContext.getExecutionManager();
        TaskManager taskManager = commandContext.getTaskManager();
        ExternalTaskManager externalTaskManager = commandContext.getExternalTaskManager();
        if (this.processInstanceId != null) {
            executionManager.updateExecutionSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
        } else if (this.processDefinitionId != null) {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.isProcessDefinitionTenantIdSet) {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
        } else {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
        }
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), this.processInstanceId, this.processDefinitionId, this.processDefinitionKey, propertyChange);
    }

    protected UpdateJobSuspensionStateBuilderImpl createJobCommandBuilder() {
        UpdateJobSuspensionStateBuilderImpl builder = new UpdateJobSuspensionStateBuilderImpl();
        if (this.processInstanceId != null) {
            builder.byProcessDefinitionId(this.processInstanceId);
        } else if (this.processDefinitionId != null) {
            builder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            builder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.isProcessDefinitionTenantIdSet && this.processDefinitionTenantId != null) {
                return builder.processDefinitionTenantId(this.processDefinitionTenantId);
            }
            if (this.isProcessDefinitionTenantIdSet) {
                return builder.processDefinitionWithoutTenantId();
            }
        }
        return builder;
    }

    @Override
    protected AbstractSetJobStateCmd getNextCommand() {
        UpdateJobSuspensionStateBuilderImpl jobCommandBuilder = this.createJobCommandBuilder();
        return this.getNextCommand(jobCommandBuilder);
    }

    protected abstract AbstractSetJobStateCmd getNextCommand(UpdateJobSuspensionStateBuilderImpl var1);
}

