/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.ProcessInstantiationBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetDeployedProcessDefinitionCmd
implements Command<ProcessDefinitionEntity> {
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionTenantId;
    protected boolean isTenantIdSet = false;
    protected final boolean checkReadPermission;

    public GetDeployedProcessDefinitionCmd(String processDefinitionId, boolean checkReadPermission) {
        this.processDefinitionId = processDefinitionId;
        this.checkReadPermission = checkReadPermission;
    }

    public GetDeployedProcessDefinitionCmd(ProcessInstantiationBuilderImpl instantiationBuilder, boolean checkReadPermission) {
        this.processDefinitionId = instantiationBuilder.getProcessDefinitionId();
        this.processDefinitionKey = instantiationBuilder.getProcessDefinitionKey();
        this.processDefinitionTenantId = instantiationBuilder.getProcessDefinitionTenantId();
        this.isTenantIdSet = instantiationBuilder.isTenantIdSet();
        this.checkReadPermission = checkReadPermission;
    }

    @Override
    public ProcessDefinitionEntity execute(CommandContext commandContext) {
        EnsureUtil.ensureOnlyOneNotNull("either process definition id or key must be set", this.processDefinitionId, this.processDefinitionKey);
        ProcessDefinitionEntity processDefinition = this.find(commandContext);
        if (this.checkReadPermission) {
            AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
            authorizationManager.checkReadProcessDefinition(processDefinition);
        }
        return processDefinition;
    }

    protected ProcessDefinitionEntity find(CommandContext commandContext) {
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        if (this.processDefinitionId != null) {
            return this.findById(deploymentCache, this.processDefinitionId);
        }
        return this.findByKey(deploymentCache, this.processDefinitionKey);
    }

    protected ProcessDefinitionEntity findById(DeploymentCache deploymentCache, String processDefinitionId) {
        return deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
    }

    protected ProcessDefinitionEntity findByKey(DeploymentCache deploymentCache, String processDefinitionKey) {
        if (this.isTenantIdSet) {
            return deploymentCache.findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, this.processDefinitionTenantId);
        }
        return deploymentCache.findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
    }
}

