/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.SignalEventReceivedBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SignalEventReceivedCmd
implements Command<Void> {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final SignalEventReceivedBuilderImpl builder;

    public SignalEventReceivedCmd(SignalEventReceivedBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String signalName = this.builder.getSignalName();
        String executionId = this.builder.getExecutionId();
        if (executionId == null) {
            this.sendSignal(commandContext, signalName);
        } else {
            this.sendSignalToExecution(commandContext, signalName, executionId);
        }
        return null;
    }

    protected void sendSignal(CommandContext commandContext, String signalName) {
        List<SignalEventSubscriptionEntity> signalEventSubscriptions = this.findSignalEventSubscriptions(commandContext, signalName);
        List<SignalEventSubscriptionEntity> catchSignalEventSubscription = this.filterIntermediateSubscriptions(signalEventSubscriptions);
        List<SignalEventSubscriptionEntity> startSignalEventSubscriptions = this.filterStartSubscriptions(signalEventSubscriptions);
        Map<String, ProcessDefinitionEntity> processDefinitions = this.getProcessDefinitionsOfSubscriptions(startSignalEventSubscriptions);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        this.checkAuthorizationOfCatchSignals(authorizationManager, catchSignalEventSubscription);
        this.checkAuthorizationOfStartSignals(authorizationManager, startSignalEventSubscriptions, processDefinitions);
        this.notifyExecutions(catchSignalEventSubscription);
        this.startProcessInstances(startSignalEventSubscriptions, processDefinitions);
    }

    protected List<SignalEventSubscriptionEntity> findSignalEventSubscriptions(CommandContext commandContext, String signalName) {
        EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        if (this.builder.isTenantIdSet()) {
            return eventSubscriptionManager.findSignalEventSubscriptionsByEventNameAndTenantId(signalName, this.builder.getTenantId());
        }
        return eventSubscriptionManager.findSignalEventSubscriptionsByEventName(signalName);
    }

    protected Map<String, ProcessDefinitionEntity> getProcessDefinitionsOfSubscriptions(List<SignalEventSubscriptionEntity> startSignalEventSubscriptions) {
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        HashMap<String, ProcessDefinitionEntity> processDefinitions = new HashMap<String, ProcessDefinitionEntity>();
        for (SignalEventSubscriptionEntity eventSubscription : startSignalEventSubscriptions) {
            String processDefinitionId = eventSubscription.getConfiguration();
            EnsureUtil.ensureNotNull("Configuration of signal start event subscription '" + eventSubscription.getId() + "' contains no process definition id.", (Object)processDefinitionId);
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
            if (processDefinition == null || processDefinition.isSuspended()) continue;
            processDefinitions.put(eventSubscription.getId(), processDefinition);
        }
        return processDefinitions;
    }

    protected void sendSignalToExecution(CommandContext commandContext, String signalName, String executionId) {
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity execution = executionManager.findExecutionById(executionId);
        EnsureUtil.ensureNotNull("Cannot find execution with id '" + executionId + "'", "execution", (Object)execution);
        EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        List<SignalEventSubscriptionEntity> signalEvents = eventSubscriptionManager.findSignalEventSubscriptionsByNameAndExecution(signalName, executionId);
        EnsureUtil.ensureNotEmpty("Execution '" + executionId + "' has not subscribed to a signal event with name '" + signalName + "'.", signalEvents);
        this.checkAuthorizationOfCatchSignals(commandContext.getAuthorizationManager(), signalEvents);
        this.notifyExecutions(signalEvents);
    }

    protected void checkAuthorizationOfCatchSignals(AuthorizationManager authorizationManager, List<SignalEventSubscriptionEntity> catchSignalEventSubscription) {
        for (SignalEventSubscriptionEntity event : catchSignalEventSubscription) {
            String processInstanceId = event.getProcessInstanceId();
            authorizationManager.checkUpdateProcessInstanceById(processInstanceId);
        }
    }

    private void checkAuthorizationOfStartSignals(AuthorizationManager authorizationManager, List<SignalEventSubscriptionEntity> startSignalEventSubscriptions, Map<String, ProcessDefinitionEntity> processDefinitions) {
        for (SignalEventSubscriptionEntity signalStartEventSubscription : startSignalEventSubscriptions) {
            ProcessDefinitionEntity processDefinition = processDefinitions.get(signalStartEventSubscription.getId());
            if (processDefinition == null) continue;
            authorizationManager.checkCreateProcessInstance(processDefinition);
        }
    }

    private void notifyExecutions(List<SignalEventSubscriptionEntity> catchSignalEventSubscription) {
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : catchSignalEventSubscription) {
            if (!this.isActiveEventSubscription(signalEventSubscriptionEntity)) continue;
            signalEventSubscriptionEntity.eventReceived(this.builder.getVariables(), false);
        }
    }

    private boolean isActiveEventSubscription(SignalEventSubscriptionEntity signalEventSubscriptionEntity) {
        ExecutionEntity execution = signalEventSubscriptionEntity.getExecution();
        return !execution.isEnded() && !execution.isCanceled();
    }

    private void startProcessInstances(List<SignalEventSubscriptionEntity> startSignalEventSubscriptions, Map<String, ProcessDefinitionEntity> processDefinitions) {
        for (SignalEventSubscriptionEntity signalStartEventSubscription : startSignalEventSubscriptions) {
            ProcessDefinitionEntity processDefinition = processDefinitions.get(signalStartEventSubscription.getId());
            if (processDefinition == null) continue;
            ActivityImpl signalStartEvent = processDefinition.findActivity(signalStartEventSubscription.getActivityId());
            PvmProcessInstance processInstance = processDefinition.createProcessInstanceForInitial(signalStartEvent);
            processInstance.start((Map<String, Object>)this.builder.getVariables());
        }
    }

    protected List<SignalEventSubscriptionEntity> filterIntermediateSubscriptions(List<SignalEventSubscriptionEntity> subscriptions) {
        ArrayList<SignalEventSubscriptionEntity> result = new ArrayList<SignalEventSubscriptionEntity>();
        for (SignalEventSubscriptionEntity subscription : subscriptions) {
            if (subscription.getExecutionId() == null) continue;
            result.add(subscription);
        }
        return result;
    }

    protected List<SignalEventSubscriptionEntity> filterStartSubscriptions(List<SignalEventSubscriptionEntity> subscriptions) {
        ArrayList<SignalEventSubscriptionEntity> result = new ArrayList<SignalEventSubscriptionEntity>();
        for (SignalEventSubscriptionEntity subscription : subscriptions) {
            if (subscription.getExecutionId() != null) continue;
            result.add(subscription);
        }
        return result;
    }
}

