/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.repository;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.repository.CaseDefinition;

public class CaseDefinitionManager
extends AbstractManager {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    public void insertCaseDefinition(CaseDefinitionEntity caseDefinition) {
        this.getDbEntityManager().insert(caseDefinition);
    }

    public void deleteCaseDefinitionsByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(CaseDefinitionEntity.class, "deleteCaseDefinitionsByDeploymentId", deploymentId);
    }

    public CaseDefinitionEntity findCaseDefinitionById(String caseDefinitionId) {
        return this.getDbEntityManager().selectById(CaseDefinitionEntity.class, caseDefinitionId);
    }

    public CaseDefinitionEntity findLatestCaseDefinitionByKey(String caseDefinitionKey) {
        List caseDefinitions = this.getDbEntityManager().selectList("selectLatestCaseDefinitionByKey", caseDefinitionKey);
        if (caseDefinitions.isEmpty()) {
            return null;
        }
        if (caseDefinitions.size() == 1) {
            return (CaseDefinitionEntity)caseDefinitions.iterator().next();
        }
        throw LOG.multipleTenantsForCaseDefinitionKeyException(caseDefinitionKey);
    }

    public CaseDefinitionEntity findLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseDefinitionKey", caseDefinitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (CaseDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestCaseDefinitionByKeyWithoutTenantId", parameters);
        }
        return (CaseDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestCaseDefinitionByKeyAndTenantId", parameters);
    }

    public CaseDefinitionEntity findCaseDefinitionByKeyVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseDefinitionVersion", caseDefinitionVersion);
        parameters.put("caseDefinitionKey", caseDefinitionKey);
        parameters.put("tenantId", tenantId);
        return (CaseDefinitionEntity)this.getDbEntityManager().selectOne("selectCaseDefinitionByKeyVersionAndTenantId", parameters);
    }

    public CaseDefinitionEntity findCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("caseDefinitionKey", caseDefinitionKey);
        return (CaseDefinitionEntity)this.getDbEntityManager().selectOne("selectCaseDefinitionByDeploymentAndKey", parameters);
    }

    public String findPreviousCaseDefinitionId(String caseDefinitionKey, Integer version, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", caseDefinitionKey);
        params.put("version", version);
        params.put("tenantId", tenantId);
        return (String)this.getDbEntityManager().selectOne("selectPreviousCaseDefinitionId", params);
    }

    public List<CaseDefinition> findCaseDefinitionsByQueryCriteria(CaseDefinitionQueryImpl caseDefinitionQuery, Page page) {
        return this.getDbEntityManager().selectList("selectCaseDefinitionsByQueryCriteria", caseDefinitionQuery, page);
    }

    public long findCaseDefinitionCountByQueryCriteria(CaseDefinitionQueryImpl caseDefinitionQuery) {
        return (Long)this.getDbEntityManager().selectOne("selectCaseDefinitionCountByQueryCriteria", caseDefinitionQuery);
    }

    public List<CaseDefinition> findCaseDefinitionByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectCaseDefinitionByDeploymentId", deploymentId);
    }
}

