/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnSentryPart;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.operation.CoreAtomicOperation;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceFactory;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableListenerInvocationListener;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableStore;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.CmmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.CaseExecutionEntityReferencer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntityFactory;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntityPersistenceListener;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceHistoryListener;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceSequenceCounterListener;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.task.TaskDecorator;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class CaseExecutionEntity
extends CmmnExecution
implements CaseExecution,
CaseInstance,
DbEntity,
HasDbRevision,
HasDbReferences,
VariableStore.VariablesProvider<VariableInstanceEntity> {
    private static final long serialVersionUID = 1L;
    protected transient CaseExecutionEntity caseInstance;
    protected transient CaseExecutionEntity parent;
    protected List<CaseExecutionEntity> caseExecutions;
    protected List<CaseSentryPartEntity> caseSentryParts;
    protected Map<String, List<CmmnSentryPart>> sentries;
    protected transient ExecutionEntity subProcessInstance;
    protected transient ExecutionEntity superExecution;
    protected transient CaseExecutionEntity subCaseInstance;
    protected transient CaseExecutionEntity superCaseExecution;
    protected VariableStore<VariableInstanceEntity> variableStore = new VariableStore<VariableInstanceEntity>(this, Arrays.asList(new CaseExecutionEntityReferencer(this)));
    protected int revision = 1;
    protected String caseDefinitionId;
    protected String activityId;
    protected String caseInstanceId;
    protected String parentId;
    protected String superCaseExecutionId;
    protected String superExecutionId;
    protected String activityName;
    protected String activityType;
    protected String activityDescription;

    @Override
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    @Override
    public CmmnCaseDefinition getCaseDefinition() {
        this.ensureCaseDefinitionInitialized();
        return this.caseDefinition;
    }

    @Override
    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        super.setCaseDefinition(caseDefinition);
        this.caseDefinitionId = null;
        if (caseDefinition != null) {
            this.caseDefinitionId = caseDefinition.getId();
        }
    }

    protected void ensureCaseDefinitionInitialized() {
        if (this.caseDefinition == null && this.caseDefinitionId != null) {
            CaseDefinitionEntity deployedCaseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().getCaseDefinitionById(this.caseDefinitionId);
            this.setCaseDefinition(deployedCaseDefinition);
        }
    }

    @Override
    public CaseExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    @Override
    public void setParent(CmmnExecution parent) {
        this.parent = (CaseExecutionEntity)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureCaseExecutionTreeInitialized();
            } else {
                this.parent = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.parentId);
            }
        }
    }

    protected void ensureCaseExecutionTreeInitialized() {
        List<CaseExecutionEntity> executions = Context.getCommandContext().getCaseExecutionManager().findChildCaseExecutionsByCaseInstanceId(this.caseInstanceId);
        CaseExecutionEntity caseInstance = null;
        HashMap<String, CaseExecutionEntity> executionMap = new HashMap<String, CaseExecutionEntity>();
        for (CaseExecutionEntity execution : executions) {
            execution.caseExecutions = new ArrayList<CaseExecutionEntity>();
            executionMap.put(execution.getId(), execution);
            if (!execution.isCaseInstanceExecution()) continue;
            caseInstance = execution;
        }
        for (CaseExecutionEntity execution : executions) {
            String parentId = execution.getParentId();
            CaseExecutionEntity parent = (CaseExecutionEntity)executionMap.get(parentId);
            if (!execution.isCaseInstanceExecution()) {
                execution.caseInstance = caseInstance;
                execution.parent = parent;
                parent.caseExecutions.add(execution);
                continue;
            }
            execution.caseInstance = execution;
        }
    }

    protected boolean isExecutionTreePrefetchEnabled() {
        return Context.getProcessEngineConfiguration().isExecutionTreePrefetchEnabled();
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public CmmnActivity getActivity() {
        this.ensureActivityInitialized();
        return super.getActivity();
    }

    @Override
    public void setActivity(CmmnActivity activity) {
        super.setActivity(activity);
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = activity.getName();
            this.activityType = this.getActivityProperty(activity, "activityType");
            this.activityDescription = this.getActivityProperty(activity, "description");
        } else {
            this.activityId = null;
            this.activityName = null;
            this.activityType = null;
            this.activityDescription = null;
        }
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.setActivity(this.getCaseDefinition().findActivity(this.activityId));
        }
    }

    protected String getActivityProperty(CmmnActivity activity, String property) {
        Object value;
        String result = null;
        if (activity != null && (value = activity.getProperty(property)) != null && value instanceof String) {
            result = (String)value;
        }
        return result;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    @Override
    public String getActivityType() {
        return this.activityType;
    }

    @Override
    public String getActivityDescription() {
        return this.activityDescription;
    }

    public List<CaseExecutionEntity> getCaseExecutions() {
        return new ArrayList<CaseExecutionEntity>(this.getCaseExecutionsInternal());
    }

    protected List<CaseExecutionEntity> getCaseExecutionsInternal() {
        this.ensureCaseExecutionsInitialized();
        return this.caseExecutions;
    }

    protected void ensureCaseExecutionsInitialized() {
        if (this.caseExecutions == null) {
            this.caseExecutions = Context.getCommandContext().getCaseExecutionManager().findChildCaseExecutionsByParentCaseExecutionId(this.id);
        }
    }

    @Override
    public TaskEntity getTask() {
        this.ensureTaskInitialized();
        return this.task;
    }

    protected void ensureTaskInitialized() {
        if (this.task == null) {
            this.task = Context.getCommandContext().getTaskManager().findTaskByCaseExecutionId(this.id);
        }
    }

    @Override
    public TaskEntity createTask(TaskDecorator taskDecorator) {
        TaskEntity task = super.createTask(taskDecorator);
        this.fireHistoricCaseActivityInstanceUpdate();
        return task;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public CaseExecutionEntity getCaseInstance() {
        this.ensureCaseInstanceInitialized();
        return this.caseInstance;
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (CaseExecutionEntity)caseInstance;
        if (caseInstance != null) {
            this.caseInstanceId = this.caseInstance.getId();
        }
    }

    protected void ensureCaseInstanceInitialized() {
        if (this.caseInstance == null && this.caseInstanceId != null) {
            this.caseInstance = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.caseInstanceId);
        }
    }

    @Override
    public boolean isCaseInstanceExecution() {
        return this.parentId == null;
    }

    @Override
    protected CaseExecutionEntity createCaseExecution(CmmnActivity activity) {
        CaseExecutionEntity child = this.newCaseExecution();
        child.setActivity(activity);
        child.setParent(this);
        this.getCaseExecutionsInternal().add(child);
        child.setCaseInstance(this.getCaseInstance());
        child.setCaseDefinition(this.getCaseDefinition());
        return child;
    }

    @Override
    protected CaseExecutionEntity newCaseExecution() {
        CaseExecutionEntity newCaseExecution = new CaseExecutionEntity();
        Context.getCommandContext().getCaseExecutionManager().insertCaseExecution(newCaseExecution);
        return newCaseExecution;
    }

    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    public void setSuperExecutionId(String superProcessExecutionId) {
        this.superExecutionId = superProcessExecutionId;
    }

    @Override
    public ExecutionEntity getSuperExecution() {
        this.ensureSuperExecutionInstanceInitialized();
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(PvmExecutionImpl superExecution) {
        this.superExecution = (ExecutionEntity)superExecution;
        this.superExecutionId = superExecution != null ? superExecution.getId() : null;
    }

    protected void ensureSuperExecutionInstanceInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = Context.getCommandContext().getExecutionManager().findExecutionById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(PvmExecutionImpl subProcessInstance) {
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        return this.createSubProcessInstance(processDefinition, businessKey, this.getCaseInstanceId());
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        ExecutionEntity subProcessInstance = (ExecutionEntity)processDefinition.createProcessInstance(businessKey, caseInstanceId);
        subProcessInstance.setSuperCaseExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        this.fireHistoricCaseActivityInstanceUpdate();
        return subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionManager().findSubProcessInstanceBySuperCaseExecutionId(this.id);
        }
    }

    @Override
    public CaseExecutionEntity getSubCaseInstance() {
        this.ensureSubCaseInstanceInitialized();
        return this.subCaseInstance;
    }

    @Override
    public void setSubCaseInstance(CmmnExecution subCaseInstance) {
        this.subCaseInstance = (CaseExecutionEntity)subCaseInstance;
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition) {
        return this.createSubCaseInstance(caseDefinition, null);
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition, String businessKey) {
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)caseDefinition.createCaseInstance(businessKey);
        subCaseInstance.setSuperCaseExecution(this);
        this.setSubCaseInstance(subCaseInstance);
        this.fireHistoricCaseActivityInstanceUpdate();
        return subCaseInstance;
    }

    public void fireHistoricCaseActivityInstanceUpdate() {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_UPDATE, this)) {
            CmmnHistoryEventProducer eventProducer = configuration.getCmmnHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent event = eventProducer.createCaseActivityInstanceUpdateEvt(this);
            eventHandler.handleEvent(event);
        }
    }

    protected void ensureSubCaseInstanceInitialized() {
        if (this.subCaseInstance == null) {
            this.subCaseInstance = Context.getCommandContext().getCaseExecutionManager().findSubCaseInstanceBySuperCaseExecutionId(this.id);
        }
    }

    public String getSuperCaseExecutionId() {
        return this.superCaseExecutionId;
    }

    public void setSuperCaseExecutionId(String superCaseExecutionId) {
        this.superCaseExecutionId = superCaseExecutionId;
    }

    @Override
    public CmmnExecution getSuperCaseExecution() {
        this.ensureSuperCaseExecutionInitialized();
        return this.superCaseExecution;
    }

    @Override
    public void setSuperCaseExecution(CmmnExecution superCaseExecution) {
        this.superCaseExecution = (CaseExecutionEntity)superCaseExecution;
        this.superCaseExecutionId = superCaseExecution != null ? superCaseExecution.getId() : null;
    }

    protected void ensureSuperCaseExecutionInitialized() {
        if (this.superCaseExecution == null && this.superCaseExecutionId != null) {
            this.superCaseExecution = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.superCaseExecutionId);
        }
    }

    public List<CaseSentryPartEntity> getCaseSentryParts() {
        this.ensureCaseSentryPartsInitialized();
        return this.caseSentryParts;
    }

    protected void ensureCaseSentryPartsInitialized() {
        if (this.caseSentryParts == null) {
            this.caseSentryParts = Context.getCommandContext().getCaseSentryPartManager().findCaseSentryPartsByCaseExecutionId(this.id);
            this.sentries = new HashMap<String, List<CmmnSentryPart>>();
            for (CaseSentryPartEntity sentryPart : this.caseSentryParts) {
                String sentryId = sentryPart.getSentryId();
                List<CmmnSentryPart> parts = this.sentries.get(sentryId);
                if (parts == null) {
                    parts = new ArrayList<CmmnSentryPart>();
                    this.sentries.put(sentryId, parts);
                }
                parts.add(sentryPart);
            }
        }
    }

    @Override
    protected void addSentryPart(CmmnSentryPart sentryPart) {
        CaseSentryPartEntity entity = (CaseSentryPartEntity)sentryPart;
        this.getCaseSentryParts().add(entity);
        String sentryId = sentryPart.getSentryId();
        List<CmmnSentryPart> parts = this.sentries.get(sentryId);
        if (parts == null) {
            parts = new ArrayList<CmmnSentryPart>();
            this.sentries.put(sentryId, parts);
        }
        parts.add(entity);
    }

    @Override
    protected Map<String, List<CmmnSentryPart>> getSentries() {
        this.ensureCaseSentryPartsInitialized();
        return this.sentries;
    }

    protected List<CmmnSentryPart> findSentry(String sentryId) {
        this.ensureCaseSentryPartsInitialized();
        return this.sentries.get(sentryId);
    }

    @Override
    protected CaseSentryPartEntity newSentryPart() {
        CaseSentryPartEntity caseSentryPart = new CaseSentryPartEntity();
        Context.getCommandContext().getCaseSentryPartManager().insertCaseSentryPart(caseSentryPart);
        return caseSentryPart;
    }

    @Override
    protected VariableStore<CoreVariableInstance> getVariableStore() {
        return this.variableStore;
    }

    @Override
    protected VariableInstanceFactory<CoreVariableInstance> getVariableInstanceFactory() {
        return VariableInstanceEntityFactory.INSTANCE;
    }

    @Override
    protected List<VariableInstanceLifecycleListener<CoreVariableInstance>> getVariableInstanceLifecycleListeners(AbstractVariableScope sourceScope) {
        return Arrays.asList(VariableInstanceEntityPersistenceListener.INSTANCE, VariableInstanceSequenceCounterListener.INSTANCE, VariableInstanceHistoryListener.INSTANCE, VariableListenerInvocationListener.INSTANCE);
    }

    @Override
    public Collection<VariableInstanceEntity> provideVariables() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByCaseExecutionId(this.id);
    }

    @Override
    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CaseExecution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public void remove() {
        super.remove();
        for (VariableInstanceEntity variableInstance : this.variableStore.getVariables()) {
            this.invokeVariableLifecycleListenersDelete(variableInstance, this, Arrays.asList(VariableInstanceEntityPersistenceListener.INSTANCE));
            this.variableStore.removeVariable(variableInstance.getName());
        }
        CommandContext commandContext = Context.getCommandContext();
        for (CaseSentryPartEntity sentryPart : this.getCaseSentryParts()) {
            commandContext.getCaseSentryPartManager().deleteSentryPart(sentryPart);
        }
        commandContext.getCaseExecutionManager().deleteCaseExecution(this);
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void forceUpdate() {
        Context.getCommandContext().getDbEntityManager().forceUpdate(this);
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referenceIds = new HashSet<String>();
        if (this.parentId != null) {
            referenceIds.add(this.parentId);
        }
        if (this.superCaseExecutionId != null) {
            referenceIds.add(this.superCaseExecutionId);
        }
        return referenceIds;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("caseDefinitionId", this.caseDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("parentId", this.parentId);
        persistentState.put("currentState", this.currentState);
        persistentState.put("previousState", this.previousState);
        return persistentState;
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance() {
        if (this.caseDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findCmmnModelInstanceForCaseDefinition(this.caseDefinitionId);
        }
        return null;
    }

    @Override
    public CmmnElement getCmmnModelElementInstance() {
        CmmnModelInstance cmmnModelInstance = this.getCmmnModelInstance();
        if (cmmnModelInstance != null) {
            ModelElementInstance modelElementInstance = cmmnModelInstance.getModelElementById(this.activityId);
            try {
                return (CmmnElement)modelElementInstance;
            }
            catch (ClassCastException e) {
                ModelElementType elementType = modelElementInstance.getElementType();
                throw new ProcessEngineException("Cannot cast " + modelElementInstance + " to CmmnElement. " + "Is of type " + elementType.getTypeName() + " Namespace " + elementType.getTypeNamespace(), e);
            }
        }
        return null;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }

    @Override
    public <T extends CoreExecution> void performOperation(CoreAtomicOperation<T> operation) {
        Context.getCommandContext().performOperation((CmmnAtomicOperation)operation, this);
    }

    @Override
    public <T extends CoreExecution> void performOperationSync(CoreAtomicOperation<T> operation) {
        Context.getCommandContext().performOperation((CmmnAtomicOperation)operation, this);
    }
}

