/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.dmn.DecisionEvaluationBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.util.DecisionTableUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class EvaluateDecisionCmd
implements Command<DmnDecisionTableResult> {
    protected String decisionDefinitionKey;
    protected String decisionDefinitionId;
    protected Integer version;
    protected VariableMap variables;
    protected String decisionDefinitionTenantId;
    protected boolean isTenandIdSet;

    public EvaluateDecisionCmd(DecisionEvaluationBuilderImpl builder) {
        this.decisionDefinitionKey = builder.getDecisionDefinitionKey();
        this.decisionDefinitionId = builder.getDecisionDefinitionId();
        this.version = builder.getVersion();
        this.variables = Variables.fromMap(builder.getVariables());
        this.decisionDefinitionTenantId = builder.getDecisionDefinitionTenantId();
        this.isTenandIdSet = builder.isTenantIdSet();
    }

    @Override
    public DmnDecisionTableResult execute(CommandContext commandContext) {
        EnsureUtil.ensureOnlyOneNotNull("either decision definition id or key must be set", this.decisionDefinitionId, this.decisionDefinitionKey);
        DecisionDefinition decisionDefinition = this.getDecisionDefinition(commandContext);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkEvaluateDecision(decisionDefinition.getKey());
        return this.doEvaluateDecision(decisionDefinition, this.variables);
    }

    protected DmnDecisionTableResult doEvaluateDecision(DecisionDefinition decisionDefinition, VariableMap variables) {
        try {
            return DecisionTableUtil.evaluateDecisionTable(decisionDefinition, variables);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception while evaluating decision with key '" + this.decisionDefinitionKey + "'", e);
        }
    }

    protected DecisionDefinition getDecisionDefinition(CommandContext commandContext) {
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        if (this.decisionDefinitionId != null) {
            return this.findById(deploymentCache);
        }
        return this.findByKey(deploymentCache);
    }

    protected DecisionDefinition findById(DeploymentCache deploymentCache) {
        return deploymentCache.findDeployedDecisionDefinitionById(this.decisionDefinitionId);
    }

    protected DecisionDefinition findByKey(DeploymentCache deploymentCache) {
        DecisionDefinition decisionDefinition = null;
        if (this.version == null && !this.isTenandIdSet) {
            decisionDefinition = deploymentCache.findDeployedLatestDecisionDefinitionByKey(this.decisionDefinitionKey);
        } else if (this.version == null && this.isTenandIdSet) {
            decisionDefinition = deploymentCache.findDeployedLatestDecisionDefinitionByKeyAndTenantId(this.decisionDefinitionKey, this.decisionDefinitionTenantId);
        } else if (this.version != null && !this.isTenandIdSet) {
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyAndVersion(this.decisionDefinitionKey, this.version);
        } else if (this.version != null && this.isTenandIdSet) {
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyVersionAndTenantId(this.decisionDefinitionKey, this.version, this.decisionDefinitionTenantId);
        }
        return decisionDefinition;
    }
}

