/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.handler;

import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricScopeInstanceEvent;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;

public class DbHistoryEventHandler
implements HistoryEventHandler {
    @Override
    public void handleEvent(HistoryEvent historyEvent) {
        if (historyEvent instanceof HistoricVariableUpdateEventEntity) {
            this.insertHistoricVariableUpdateEntity((HistoricVariableUpdateEventEntity)historyEvent);
        } else if (historyEvent instanceof HistoricDecisionInstanceEntity) {
            this.insertHistoricDecisionInstanceEntity((HistoricDecisionInstanceEntity)historyEvent);
        } else {
            this.insertOrUpdate(historyEvent);
        }
    }

    @Override
    public void handleEvents(List<HistoryEvent> historyEvents) {
        for (HistoryEvent historyEvent : historyEvents) {
            this.handleEvent(historyEvent);
        }
    }

    protected void insertOrUpdate(HistoryEvent historyEvent) {
        DbEntityManager dbEntityManager = this.getDbEntityManager();
        String eventType = historyEvent.getEventType();
        if (eventType == null || this.isInitialEvent(eventType)) {
            dbEntityManager.insert(historyEvent);
        } else if (dbEntityManager.getCachedEntity(historyEvent.getClass(), historyEvent.getId()) == null) {
            HistoricScopeInstanceEvent existingEvent;
            if (historyEvent instanceof HistoricScopeInstanceEvent && (existingEvent = (HistoricScopeInstanceEvent)dbEntityManager.selectById(historyEvent.getClass(), historyEvent.getId())) != null) {
                HistoricScopeInstanceEvent historicScopeInstanceEvent = (HistoricScopeInstanceEvent)historyEvent;
                historicScopeInstanceEvent.setStartTime(existingEvent.getStartTime());
            }
            if (historyEvent.getId() != null) {
                dbEntityManager.merge(historyEvent);
            }
        }
    }

    protected void insertHistoricVariableUpdateEntity(HistoricVariableUpdateEventEntity historyEvent) {
        HistoricVariableInstanceEntity historicVariableInstanceEntity;
        DbEntityManager dbEntityManager = this.getDbEntityManager();
        if (Context.getProcessEngineConfiguration().getHistoryLevel().isHistoryEventProduced(HistoryEventTypes.VARIABLE_INSTANCE_UPDATE_DETAIL, historyEvent)) {
            byte[] byteValue = historyEvent.getByteValue();
            if (byteValue != null) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(historyEvent.getVariableName(), byteValue);
                Context.getCommandContext().getDbEntityManager().insert(byteArrayEntity);
                historyEvent.setByteArrayId(byteArrayEntity.getId());
            }
            dbEntityManager.insert(historyEvent);
        }
        if (HistoryEventTypes.VARIABLE_INSTANCE_CREATE.getEventName().equals(historyEvent.getEventType())) {
            HistoricVariableInstanceEntity persistentObject = new HistoricVariableInstanceEntity(historyEvent);
            dbEntityManager.insert(persistentObject);
        } else if (HistoryEventTypes.VARIABLE_INSTANCE_UPDATE.getEventName().equals(historyEvent.getEventType())) {
            historicVariableInstanceEntity = dbEntityManager.selectById(HistoricVariableInstanceEntity.class, historyEvent.getVariableInstanceId());
            if (historicVariableInstanceEntity != null) {
                historicVariableInstanceEntity.updateFromEvent(historyEvent);
            } else {
                HistoricVariableInstanceEntity persistentObject = new HistoricVariableInstanceEntity(historyEvent);
                dbEntityManager.insert(persistentObject);
            }
        } else if (HistoryEventTypes.VARIABLE_INSTANCE_DELETE.getEventName().equals(historyEvent.getEventType()) && (historicVariableInstanceEntity = dbEntityManager.selectById(HistoricVariableInstanceEntity.class, historyEvent.getVariableInstanceId())) != null) {
            historicVariableInstanceEntity.delete();
        }
    }

    protected void insertHistoricDecisionInstanceEntity(HistoricDecisionInstanceEntity historicDecisionInstanceEntity) {
        Context.getCommandContext().getHistoricDecisionInstanceManager().insertHistoricDecisionInstance(historicDecisionInstanceEntity);
    }

    protected boolean isInitialEvent(String eventType) {
        return HistoryEventTypes.ACTIVITY_INSTANCE_START.getEventName().equals(eventType) || HistoryEventTypes.PROCESS_INSTANCE_START.getEventName().equals(eventType) || HistoryEventTypes.TASK_INSTANCE_CREATE.getEventName().equals(eventType) || HistoryEventTypes.FORM_PROPERTY_UPDATE.getEventName().equals(eventType) || HistoryEventTypes.INCIDENT_CREATE.getEventName().equals(eventType) || HistoryEventTypes.CASE_INSTANCE_CREATE.getEventName().equals(eventType) || HistoryEventTypes.DMN_DECISION_EVALUATE.getEventName().equals(eventType) || HistoryEventTypes.BATCH_START.getEventName().equals(eventType);
    }

    protected DbEntityManager getDbEntityManager() {
        return Context.getCommandContext().getDbEntityManager();
    }
}

