/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.producer;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationEvent;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedDecisionRule;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedInput;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedOutput;
import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.DoubleValue;
import org.camunda.bpm.engine.variable.value.IntegerValue;
import org.camunda.bpm.engine.variable.value.LongValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DefaultDmnHistoryEventProducer
implements DmnHistoryEventProducer {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(DelegateExecution execution, DmnDecisionTableEvaluationEvent evaluationEvent) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(executionEntity, evaluationEvent);
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE);
        this.setReferenceToProcessInstance(event, executionEntity);
        event.setEvaluationTime(ClockUtil.getCurrentTime());
        DecisionDefinition decisionDefinition = (DecisionDefinition)evaluationEvent.getDecisionTable();
        String tenantId = execution.getTenantId();
        if (tenantId == null) {
            tenantId = this.provideTenantId(decisionDefinition, event);
        }
        event.setTenantId(tenantId);
        return event;
    }

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(DelegateCaseExecution execution, DmnDecisionTableEvaluationEvent evaluationEvent) {
        CaseExecutionEntity executionEntity = (CaseExecutionEntity)execution;
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(executionEntity, evaluationEvent);
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE);
        this.setReferenceToCaseInstance(event, executionEntity);
        event.setEvaluationTime(ClockUtil.getCurrentTime());
        return event;
    }

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(DmnDecisionTableEvaluationEvent evaluationEvent) {
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(evaluationEvent);
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE);
        event.setEvaluationTime(ClockUtil.getCurrentTime());
        this.setUserId(event);
        DmnDecision decisionTable = evaluationEvent.getDecisionTable();
        String tenantId = ((DecisionDefinition)decisionTable).getTenantId();
        if (tenantId == null) {
            tenantId = this.provideTenantId((DecisionDefinition)decisionTable, event);
        }
        event.setTenantId(tenantId);
        return event;
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(ExecutionEntity executionEntity, DmnDecisionTableEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(CaseExecutionEntity executionEntity, DmnDecisionTableEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(DmnDecisionTableEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected void initDecisionInstanceEvent(HistoricDecisionInstanceEntity event, DmnDecisionTableEvaluationEvent evaluationEvent, HistoryEventTypes eventType) {
        event.setEventType(eventType.getEventName());
        DmnDecision decisionTable = evaluationEvent.getDecisionTable();
        event.setDecisionDefinitionId(((DecisionDefinition)decisionTable).getId());
        event.setDecisionDefinitionKey(decisionTable.getKey());
        event.setDecisionDefinitionName(decisionTable.getName());
        if (evaluationEvent.getCollectResultValue() != null) {
            Double collectResultValue = this.getCollectResultValue(evaluationEvent.getCollectResultValue());
            event.setCollectResultValue(collectResultValue);
        }
        List<HistoricDecisionInputInstance> historicDecisionInputInstances = this.createHistoricDecisionInputInstances(evaluationEvent);
        event.setInputs(historicDecisionInputInstances);
        List<HistoricDecisionOutputInstance> historicDecisionOutputInstances = this.createHistoricDecisionOutputInstances(evaluationEvent);
        event.setOutputs(historicDecisionOutputInstances);
    }

    protected Double getCollectResultValue(TypedValue collectResultValue) {
        if (collectResultValue instanceof IntegerValue) {
            return ((Integer)((IntegerValue)collectResultValue).getValue()).doubleValue();
        }
        if (collectResultValue instanceof LongValue) {
            return ((Long)((LongValue)collectResultValue).getValue()).doubleValue();
        }
        if (collectResultValue instanceof DoubleValue) {
            return (Double)((DoubleValue)collectResultValue).getValue();
        }
        throw LOG.collectResultValueOfUnsupportedTypeException(collectResultValue);
    }

    protected List<HistoricDecisionInputInstance> createHistoricDecisionInputInstances(DmnDecisionTableEvaluationEvent evaluationEvent) {
        ArrayList<HistoricDecisionInputInstance> inputInstances = new ArrayList<HistoricDecisionInputInstance>();
        for (DmnEvaluatedInput inputClause : evaluationEvent.getInputs()) {
            HistoricDecisionInputInstanceEntity inputInstance = new HistoricDecisionInputInstanceEntity();
            inputInstance.setClauseId(inputClause.getId());
            inputInstance.setClauseName(inputClause.getName());
            TypedValue typedValue = Variables.untypedValue((Object)inputClause.getValue());
            inputInstance.setValue(typedValue);
            inputInstances.add(inputInstance);
        }
        return inputInstances;
    }

    protected List<HistoricDecisionOutputInstance> createHistoricDecisionOutputInstances(DmnDecisionTableEvaluationEvent evaluationEvent) {
        ArrayList<HistoricDecisionOutputInstance> outputInstances = new ArrayList<HistoricDecisionOutputInstance>();
        List matchingRules = evaluationEvent.getMatchingRules();
        for (int index = 0; index < matchingRules.size(); ++index) {
            DmnEvaluatedDecisionRule rule = (DmnEvaluatedDecisionRule)matchingRules.get(index);
            String ruleId = rule.getId();
            Integer ruleOrder = index + 1;
            for (DmnEvaluatedOutput outputClause : rule.getOutputEntries().values()) {
                HistoricDecisionOutputInstanceEntity outputInstance = new HistoricDecisionOutputInstanceEntity();
                outputInstance.setClauseId(outputClause.getId());
                outputInstance.setClauseName(outputClause.getName());
                outputInstance.setRuleId(ruleId);
                outputInstance.setRuleOrder(ruleOrder);
                outputInstance.setVariableName(outputClause.getOutputName());
                TypedValue typedValue = Variables.untypedValue((Object)outputClause.getValue());
                outputInstance.setValue(typedValue);
                outputInstances.add(outputInstance);
            }
        }
        return outputInstances;
    }

    protected void setReferenceToProcessInstance(HistoricDecisionInstanceEntity event, ExecutionEntity execution) {
        event.setProcessDefinitionKey(this.getProcessDefinitionKey(execution));
        event.setProcessDefinitionId(execution.getProcessDefinitionId());
        event.setProcessInstanceId(execution.getProcessInstanceId());
        event.setExecutionId(execution.getId());
        event.setActivityId(execution.getActivityId());
        event.setActivityInstanceId(execution.getActivityInstanceId());
    }

    protected String getProcessDefinitionKey(ExecutionEntity execution) {
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)execution.getProcessDefinition();
        if (definition != null) {
            return definition.getKey();
        }
        return null;
    }

    protected void setReferenceToCaseInstance(HistoricDecisionInstanceEntity event, CaseExecutionEntity execution) {
        event.setCaseDefinitionKey(this.getCaseDefinitionKey(execution));
        event.setCaseDefinitionId(execution.getCaseDefinitionId());
        event.setCaseInstanceId(execution.getCaseInstanceId());
        event.setExecutionId(execution.getId());
        event.setActivityId(execution.getActivityId());
        event.setActivityInstanceId(execution.getId());
    }

    protected String getCaseDefinitionKey(CaseExecutionEntity execution) {
        CaseDefinitionEntity definition = (CaseDefinitionEntity)execution.getCaseDefinition();
        if (definition != null) {
            return definition.getKey();
        }
        return null;
    }

    protected void setUserId(HistoricDecisionInstanceEntity event) {
        event.setUserId(Context.getCommandContext().getAuthenticatedUserId());
    }

    protected String provideTenantId(DecisionDefinition decisionDefinition, HistoricDecisionInstanceEntity event) {
        TenantIdProvider tenantIdProvider = Context.getProcessEngineConfiguration().getTenantIdProvider();
        String tenantId = null;
        if (tenantIdProvider != null) {
            TenantIdProviderHistoricDecisionInstanceContext ctx = null;
            ctx = event.getExecutionId() != null ? new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition, this.getExecution(event)) : (event.getCaseExecutionId() != null ? new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition, this.getCaseExecution(event)) : new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition));
            tenantId = tenantIdProvider.provideTenantIdForHistoricDecisionInstance(ctx);
        }
        return tenantId;
    }

    protected DelegateExecution getExecution(HistoricDecisionInstanceEntity event) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(event.getExecutionId());
    }

    protected DelegateCaseExecution getCaseExecution(HistoricDecisionInstanceEntity event) {
        return Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(event.getCaseExecutionId());
    }
}

