/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.identity.db;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.identity.db.DbGroupQueryImpl;
import org.camunda.bpm.engine.impl.identity.db.DbUserQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;

public class DbReadOnlyIdentityServiceProvider
extends AbstractManager
implements ReadOnlyIdentityProvider {
    @Override
    public UserEntity findUserById(String userId) {
        this.checkAuthorization(Permissions.READ, Resources.USER, userId);
        return this.getDbEntityManager().selectById(UserEntity.class, userId);
    }

    @Override
    public UserQuery createUserQuery() {
        return new DbUserQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    @Override
    public UserQueryImpl createUserQuery(CommandContext commandContext) {
        return new DbUserQueryImpl();
    }

    public long findUserCountByQueryCriteria(DbUserQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.USER);
        return (Long)this.getDbEntityManager().selectOne("selectUserCountByQueryCriteria", query);
    }

    public List<User> findUserByQueryCriteria(DbUserQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.USER);
        return this.getDbEntityManager().selectList("selectUserByQueryCriteria", query);
    }

    @Override
    public boolean checkPassword(String userId, String password) {
        UserEntity user = this.findUserById(userId);
        return user != null && password != null && this.matchPassword(password, user);
    }

    protected boolean matchPassword(String password, User user) {
        return Context.getProcessEngineConfiguration().getPasswordEncryptor().check(password, user.getPassword());
    }

    @Override
    public GroupEntity findGroupById(String groupId) {
        this.checkAuthorization(Permissions.READ, Resources.GROUP, groupId);
        return this.getDbEntityManager().selectById(GroupEntity.class, groupId);
    }

    @Override
    public GroupQuery createGroupQuery() {
        return new DbGroupQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    @Override
    public GroupQuery createGroupQuery(CommandContext commandContext) {
        return new DbGroupQueryImpl();
    }

    public long findGroupCountByQueryCriteria(DbGroupQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.GROUP);
        return (Long)this.getDbEntityManager().selectOne("selectGroupCountByQueryCriteria", query);
    }

    public List<Group> findGroupByQueryCriteria(DbGroupQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.GROUP);
        return this.getDbEntityManager().selectList("selectGroupByQueryCriteria", query);
    }

    protected void configureQuery(AbstractQuery query, Resource resource) {
        Context.getCommandContext().getAuthorizationManager().configureQuery(query, resource);
    }

    @Override
    protected void checkAuthorization(Permission permission, Resource resource, String resourceId) {
        Context.getCommandContext().getAuthorizationManager().checkAuthorization(permission, resource, resourceId);
    }
}

