/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public abstract class TimerChangeJobDefinitionSuspensionStateJobHandler
implements JobHandler {
    protected static final String JOB_HANDLER_CFG_BY = "by";
    protected static final String JOB_HANDLER_CFG_JOB_DEFINITION_ID = "jobDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    protected static final String JOB_HANDLER_CFG_INCLUDE_JOBS = "includeJobs";

    public static String createJobHandlerConfigurationByJobDefinitionId(String jobDefinitionId, boolean includeJobs) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_JOB_DEFINITION_ID);
        json.put(JOB_HANDLER_CFG_JOB_DEFINITION_ID, jobDefinitionId);
        json.put(JOB_HANDLER_CFG_INCLUDE_JOBS, includeJobs);
        return json.toString();
    }

    public static String createJobHandlerConfigurationByProcessDefinitionId(String processDefinitionId, boolean includeJobs) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID, processDefinitionId);
        json.put(JOB_HANDLER_CFG_INCLUDE_JOBS, includeJobs);
        return json.toString();
    }

    public static String createJobHandlerConfigurationByProcessDefinitionKey(String processDefinitionKey, boolean includeJobs) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, processDefinitionKey);
        json.put(JOB_HANDLER_CFG_INCLUDE_JOBS, includeJobs);
        return json.toString();
    }

    public static String createJobHandlerConfigurationByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, boolean includeJobs) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, processDefinitionKey);
        json.put(JOB_HANDLER_CFG_INCLUDE_JOBS, includeJobs);
        if (processDefinitionTenantId != null) {
            json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, processDefinitionTenantId);
        } else {
            json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, JSONObject.NULL);
        }
        return json.toString();
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        AbstractSetJobDefinitionStateCmd cmd = this.getCommand(configuration);
        cmd.disableLogUserOperation();
        cmd.execute(commandContext);
    }

    protected String getJobDefinitionId(JSONObject configuration) {
        return configuration.getString(JOB_HANDLER_CFG_JOB_DEFINITION_ID);
    }

    protected String getProcessDefinitionId(JSONObject configuration) {
        return configuration.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
    }

    protected String getProcessDefinitionKey(JSONObject configuration) {
        return configuration.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
    }

    protected boolean getIncludeJobs(JSONObject configuration) {
        return configuration.getBoolean(JOB_HANDLER_CFG_INCLUDE_JOBS);
    }

    protected String getBy(JSONObject configuration) {
        return configuration.getString(JOB_HANDLER_CFG_BY);
    }

    protected boolean isProcessDefinitionTenantIdSet(JSONObject config) {
        return config.has(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID);
    }

    protected String getProcessDefinitionTenantId(JSONObject config) {
        if (config.isNull(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID)) {
            return null;
        }
        return config.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID);
    }

    protected UpdateJobDefinitionSuspensionStateBuilderImpl createBuilder(JSONObject config) {
        UpdateJobDefinitionSuspensionStateBuilderImpl builder = new UpdateJobDefinitionSuspensionStateBuilderImpl();
        String by = this.getBy(config);
        if (by.equals(JOB_HANDLER_CFG_JOB_DEFINITION_ID)) {
            builder.byJobDefinitionId(this.getJobDefinitionId(config));
        } else if (by.equals(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID)) {
            builder.byProcessDefinitionId(this.getProcessDefinitionId(config));
        } else if (by.equals(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY)) {
            builder.byProcessDefinitionKey(this.getProcessDefinitionKey(config));
            if (this.isProcessDefinitionTenantIdSet(config)) {
                String processDefinitionTenantId = this.getProcessDefinitionTenantId(config);
                if (processDefinitionTenantId != null) {
                    builder.processDefinitionTenantId(processDefinitionTenantId);
                } else {
                    builder.processDefinitionWithoutTenantId();
                }
            }
        } else {
            throw new ProcessEngineException("Unexpected job handler configuration for property 'by': " + by);
        }
        return builder;
    }

    protected abstract AbstractSetJobDefinitionStateCmd getCommand(String var1);
}

