/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetProcessDefinitionStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.repository.UpdateProcessDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public abstract class TimerChangeProcessDefinitionSuspensionStateJobHandler
implements JobHandler {
    protected static final String JOB_HANDLER_CFG_BY = "by";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    protected static final String JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES = "includeProcessInstances";

    public static String createJobHandlerConfigurationByProcessDefinitionId(String processDefinitionId, boolean includeProcessInstances) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID, processDefinitionId);
        json.put(JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES, includeProcessInstances);
        return json.toString();
    }

    public static String createJobHandlerConfigurationByProcessDefinitionKey(String processDefinitionKey, boolean includeProcessInstances) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, processDefinitionKey);
        json.put(JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES, includeProcessInstances);
        return json.toString();
    }

    public static String createJobHandlerConfigurationByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String tenantId, boolean includeProcessInstances) {
        JSONObject json = new JSONObject();
        json.put(JOB_HANDLER_CFG_BY, JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
        json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, processDefinitionKey);
        json.put(JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES, includeProcessInstances);
        if (tenantId != null) {
            json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, tenantId);
        } else {
            json.put(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, JSONObject.NULL);
        }
        return json.toString();
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        AbstractSetProcessDefinitionStateCmd cmd = this.getCommand(configuration);
        cmd.disableLogUserOperation();
        cmd.execute(commandContext);
    }

    protected String getProcessDefinitionId(JSONObject config) {
        return config.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
    }

    protected String getProcessDefinitionKey(JSONObject config) {
        return config.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
    }

    protected String getBy(JSONObject config) {
        return config.getString(JOB_HANDLER_CFG_BY);
    }

    protected boolean getIncludeProcessInstances(JSONObject config) {
        return config.getBoolean(JOB_HANDLER_CFG_INCLUDE_PROCESS_INSTANCES);
    }

    protected boolean isTenantIdSet(JSONObject config) {
        return config.has(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID);
    }

    protected String getTenantId(JSONObject config) {
        if (config.isNull(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID)) {
            return null;
        }
        return config.getString(JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID);
    }

    protected UpdateProcessDefinitionSuspensionStateBuilderImpl createBuilder(JSONObject config) {
        UpdateProcessDefinitionSuspensionStateBuilderImpl builder = new UpdateProcessDefinitionSuspensionStateBuilderImpl();
        String by = this.getBy(config);
        if (by.equals(JOB_HANDLER_CFG_PROCESS_DEFINITION_ID)) {
            builder.byProcessDefinitionId(this.getProcessDefinitionId(config));
        } else if (by.equals(JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY)) {
            builder.byProcessDefinitionKey(this.getProcessDefinitionKey(config));
            if (this.isTenantIdSet(config)) {
                String tenantId = this.getTenantId(config);
                if (tenantId != null) {
                    builder.processDefinitionTenantId(tenantId);
                } else {
                    builder.processDefinitionWithoutTenantId();
                }
            }
        } else {
            throw new ProcessEngineException("Unexpected job handler configuration for property 'by': " + by);
        }
        return builder;
    }

    protected abstract AbstractSetProcessDefinitionStateCmd getCommand(String var1);
}

