/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;

public abstract class TimerEventJobHandler
implements JobHandler {
    public static final String JOB_HANDLER_CONFIG_PROPERTY_DELIMITER = "$";
    public static final String JOB_HANDLER_CONFIG_PROPERTY_FOLLOW_UP_JOB_CREATED = "followUpJobCreated";

    public static String getKey(String configuration) {
        if (TimerEventJobHandler.containsDelimiter(configuration)) {
            String[] configParts = TimerEventJobHandler.getConfigParts(configuration);
            return configParts[0];
        }
        return configuration;
    }

    public static boolean isFollowUpJobCreated(String configuration) {
        if (TimerEventJobHandler.containsDelimiter(configuration)) {
            String[] configParts = TimerEventJobHandler.getConfigParts(configuration);
            String property = configParts[1];
            return JOB_HANDLER_CONFIG_PROPERTY_FOLLOW_UP_JOB_CREATED.equals(property);
        }
        return false;
    }

    public static String createJobHandlerConfigurationWithFollowUpJobCreated(String configuration) {
        if (configuration == null) {
            configuration = "";
        }
        configuration = configuration + "$followUpJobCreated";
        return configuration;
    }

    protected static boolean containsDelimiter(String configuration) {
        return configuration != null && configuration.contains(JOB_HANDLER_CONFIG_PROPERTY_DELIMITER);
    }

    protected static String[] getConfigParts(String configuration) {
        String[] configParts = configuration.split("\\$");
        if (configParts.length != 2) {
            throw new ProcessEngineException("Illegal timer job handler configuration: '" + configuration + "': exprecting two parts seperated by '" + JOB_HANDLER_CONFIG_PROPERTY_DELIMITER + "'.");
        }
        return configParts;
    }

    public static String updateKeyInConfiguration(String configuration, String key) {
        String newConfiguration = key;
        if (TimerEventJobHandler.containsDelimiter(configuration)) {
            String[] configParts = TimerEventJobHandler.getConfigParts(configuration);
            for (int i = 1; i < configParts.length; ++i) {
                newConfiguration = newConfiguration + JOB_HANDLER_CONFIG_PROPERTY_DELIMITER + configParts[i];
            }
        }
        return newConfiguration;
    }
}

