/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import java.util.List;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.migration.MigrationInstructionImpl;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class MigrationInstructionJsonConverter
extends JsonObjectConverter<MigrationInstruction> {
    public static final MigrationInstructionJsonConverter INSTANCE = new MigrationInstructionJsonConverter();
    public static final String SOURCE_ACTIVITY_IDS = "sourceActivityIds";
    public static final String TARGET_ACTIVITY_IDS = "targetActivityIds";

    @Override
    public JSONObject toJsonObject(MigrationInstruction instruction) {
        JSONObject json = new JSONObject();
        JsonUtil.addArrayField(json, SOURCE_ACTIVITY_IDS, new String[]{instruction.getSourceActivityId()});
        JsonUtil.addArrayField(json, TARGET_ACTIVITY_IDS, new String[]{instruction.getTargetActivityId()});
        return json;
    }

    @Override
    public MigrationInstruction toObject(JSONObject json) {
        return new MigrationInstructionImpl(this.readSourceActivityId(json), this.readTargetActivityId(json));
    }

    protected String readSourceActivityId(JSONObject json) {
        List<Object> sourceActivityIds = JsonUtil.jsonArrayAsList(json.getJSONArray(SOURCE_ACTIVITY_IDS));
        return (String)sourceActivityIds.get(0);
    }

    protected String readTargetActivityId(JSONObject json) {
        List<Object> targetActivityIds = JsonUtil.jsonArrayAsList(json.getJSONArray(TARGET_ACTIVITY_IDS));
        return (String)targetActivityIds.get(0);
    }
}

