/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.migration.MigrationActivityMatcher;
import org.camunda.bpm.engine.impl.migration.MigrationInstructionGenerator;
import org.camunda.bpm.engine.impl.migration.validation.activity.MigrationActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructionImpl;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class DefaultMigrationInstructionGenerator
implements MigrationInstructionGenerator {
    protected List<MigrationActivityValidator> migrationActivityValidators = new ArrayList<MigrationActivityValidator>();
    protected MigrationActivityMatcher migrationActivityMatcher;

    public DefaultMigrationInstructionGenerator(MigrationActivityMatcher migrationActivityMatcher) {
        this.migrationActivityMatcher = migrationActivityMatcher;
    }

    @Override
    public MigrationInstructionGenerator migrationActivityValidators(List<MigrationActivityValidator> migrationActivityValidators) {
        this.migrationActivityValidators = migrationActivityValidators;
        return this;
    }

    @Override
    public ValidatingMigrationInstructions generate(ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
        ValidatingMigrationInstructions migrationInstructions = new ValidatingMigrationInstructions();
        this.generate(sourceProcessDefinition, targetProcessDefinition, sourceProcessDefinition, targetProcessDefinition, migrationInstructions);
        return migrationInstructions;
    }

    public void generate(ScopeImpl sourceScope, ScopeImpl targetScope, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition, ValidatingMigrationInstructions migrationInstructions) {
        for (ActivityImpl sourceActivity : sourceScope.getActivities()) {
            for (ActivityImpl targetActivity : targetScope.getActivities()) {
                if (!this.isValidActivity(sourceActivity) || !this.isValidActivity(targetActivity) || !this.migrationActivityMatcher.matchActivities(sourceActivity, targetActivity)) continue;
                migrationInstructions.addInstruction(new ValidatingMigrationInstructionImpl(sourceActivity, targetActivity));
                this.generate(sourceActivity, targetActivity, sourceProcessDefinition, targetProcessDefinition, migrationInstructions);
            }
        }
    }

    protected boolean isValidActivity(ActivityImpl activity) {
        for (MigrationActivityValidator migrationActivityValidator : this.migrationActivityValidators) {
            if (migrationActivityValidator.valid(activity)) continue;
            return false;
        }
        return true;
    }
}

