/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstanceBranch;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstanceWalker;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParser;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class MigrateProcessInstanceCmd
implements Command<Void> {
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected MigrationPlanExecutionBuilderImpl migrationPlanExecutionBuilder;

    public MigrateProcessInstanceCmd(MigrationPlanExecutionBuilderImpl migrationPlanExecutionBuilder) {
        this.migrationPlanExecutionBuilder = migrationPlanExecutionBuilder;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        MigrationPlan migrationPlan = this.migrationPlanExecutionBuilder.getMigrationPlan();
        List<String> processInstanceIds = this.migrationPlanExecutionBuilder.getProcessInstanceIds();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Migration plan cannot be null", "migration plan", (Object)migrationPlan);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process instance ids cannot be null", "process instance ids", processInstanceIds);
        ProcessDefinitionEntity targetProcessDefinition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(migrationPlan.getTargetProcessDefinitionId());
        for (String processInstanceId : processInstanceIds) {
            this.migrateProcessInstance(commandContext, processInstanceId, migrationPlan, targetProcessDefinition);
        }
        return null;
    }

    public Void migrateProcessInstance(CommandContext commandContext, String processInstanceId, MigrationPlan migrationPlan, ProcessDefinitionEntity targetProcessDefinition) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process instance id cannot be null", "process instance id", (Object)processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        this.ensureProcessInstanceExist(processInstanceId, processInstance);
        this.ensureSameProcessDefinition(processInstance, migrationPlan.getSourceProcessDefinitionId());
        MigratingProcessInstanceValidationReportImpl processInstanceReport = new MigratingProcessInstanceValidationReportImpl();
        MigratingInstanceParser migratingInstanceParser = new MigratingInstanceParser(Context.getProcessEngineConfiguration().getProcessEngine());
        MigratingProcessInstance migratingProcessInstance = migratingInstanceParser.parse(processInstance.getId(), migrationPlan, processInstanceReport);
        this.validateInstructions(commandContext, migratingProcessInstance, processInstanceReport);
        if (processInstanceReport.hasFailures()) {
            throw LOGGER.failingMigratingProcessInstanceValidation(processInstanceReport);
        }
        this.deleteUnmappedActivityInstances(migratingProcessInstance);
        this.migrateProcessInstance(migratingProcessInstance);
        return null;
    }

    protected void deleteUnmappedActivityInstances(MigratingProcessInstance migratingProcessInstance) {
        final HashSet visitedActivityInstances = new HashSet();
        Set<MigratingActivityInstance> leafInstances = this.collectLeafInstances(migratingProcessInstance);
        for (MigratingActivityInstance leafInstance : leafInstances) {
            MigratingActivityInstanceWalker walker = new MigratingActivityInstanceWalker(leafInstance);
            walker.addPreVisitor(new TreeVisitor<MigratingActivityInstance>(){

                @Override
                public void visit(MigratingActivityInstance currentInstance) {
                    visitedActivityInstances.add(currentInstance);
                    if (!currentInstance.migrates()) {
                        HashSet<MigratingActivityInstance> children = new HashSet<MigratingActivityInstance>(currentInstance.getChildren());
                        MigratingActivityInstance parent = currentInstance.getParent();
                        currentInstance.detachChildren();
                        currentInstance.remove();
                        for (MigratingActivityInstance child : children) {
                            child.attachState(parent);
                        }
                    } else {
                        currentInstance.removeUnmappedDependentInstances();
                    }
                }
            });
            walker.walkUntil(new ReferenceWalker.WalkCondition<MigratingActivityInstance>(){

                @Override
                public boolean isFulfilled(MigratingActivityInstance element) {
                    return element == null || !visitedActivityInstances.containsAll(element.getChildren());
                }
            });
        }
    }

    protected Set<MigratingActivityInstance> collectLeafInstances(MigratingProcessInstance migratingProcessInstance) {
        HashSet<MigratingActivityInstance> leafInstances = new HashSet<MigratingActivityInstance>();
        for (MigratingActivityInstance migratingActivityInstance : migratingProcessInstance.getMigratingActivityInstances()) {
            if (!migratingActivityInstance.getChildren().isEmpty()) continue;
            leafInstances.add(migratingActivityInstance);
        }
        return leafInstances;
    }

    protected void validateInstructions(CommandContext commandContext, MigratingProcessInstance migratingProcessInstance, MigratingProcessInstanceValidationReportImpl processInstanceReport) {
        List<MigratingActivityInstanceValidator> migratingActivityInstanceValidators = commandContext.getProcessEngineConfiguration().getMigratingActivityInstanceValidators();
        for (MigratingActivityInstance migratingActivityInstance : migratingProcessInstance.getMigratingActivityInstances()) {
            MigratingActivityInstanceValidationReportImpl instanceReport = this.validateActivityInstance(migratingActivityInstance, migratingProcessInstance, migratingActivityInstanceValidators);
            if (!instanceReport.hasFailures()) continue;
            processInstanceReport.addInstanceReport(instanceReport);
        }
    }

    protected MigratingActivityInstanceValidationReportImpl validateActivityInstance(MigratingActivityInstance migratingActivityInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingActivityInstanceValidator> migratingActivityInstanceValidators) {
        MigratingActivityInstanceValidationReportImpl instanceReport = new MigratingActivityInstanceValidationReportImpl(migratingActivityInstance);
        for (MigratingActivityInstanceValidator migratingActivityInstanceValidator : migratingActivityInstanceValidators) {
            migratingActivityInstanceValidator.validate(migratingActivityInstance, migratingProcessInstance, instanceReport);
        }
        return instanceReport;
    }

    protected void migrateProcessInstance(MigratingProcessInstance migratingProcessInstance) {
        MigratingActivityInstance rootActivityInstance = migratingProcessInstance.getMigratingInstance(migratingProcessInstance.getProcessInstanceId());
        MigratingActivityInstanceBranch scopeExecutionContext = new MigratingActivityInstanceBranch();
        scopeExecutionContext.visited(rootActivityInstance);
        this.migrateActivityInstance(scopeExecutionContext, rootActivityInstance);
    }

    protected void migrateActivityInstance(MigratingActivityInstanceBranch migratingInstanceBranch, MigratingActivityInstance migratingActivityInstance) {
        ActivityInstance activityInstance = migratingActivityInstance.getActivityInstance();
        if (!activityInstance.getId().equals(activityInstance.getProcessInstanceId())) {
            ScopeImpl parentActivityInstanceTargetScope;
            MigratingActivityInstance parentMigratingInstance = migratingActivityInstance.getParent();
            ScopeImpl targetScope = migratingActivityInstance.getTargetScope();
            ScopeImpl targetFlowScope = targetScope.getFlowScope();
            if (targetFlowScope != (parentActivityInstanceTargetScope = parentMigratingInstance.getTargetScope())) {
                List<ScopeImpl> nonExistingScopes = this.collectNonExistingFlowScopes(targetFlowScope, migratingInstanceBranch);
                ScopeImpl existingScope = nonExistingScopes.isEmpty() ? targetFlowScope : nonExistingScopes.get(0).getFlowScope();
                MigratingActivityInstance ancestorScopeInstance = migratingInstanceBranch.getInstance(existingScope);
                this.instantiateScopes(ancestorScopeInstance, migratingInstanceBranch, nonExistingScopes);
                MigratingActivityInstance targetFlowScopeInstance = migratingInstanceBranch.getInstance(targetFlowScope);
                migratingActivityInstance.detachState();
                migratingActivityInstance.attachState(targetFlowScopeInstance);
            }
        }
        migratingActivityInstance.migrateState();
        migratingActivityInstance.migrateDependentEntities();
        migratingInstanceBranch = migratingInstanceBranch.copy();
        migratingInstanceBranch.visited(migratingActivityInstance);
        HashSet<MigratingActivityInstance> children = new HashSet<MigratingActivityInstance>(migratingActivityInstance.getChildren());
        for (MigratingActivityInstance childInstance : children) {
            this.migrateActivityInstance(migratingInstanceBranch, childInstance);
        }
    }

    protected List<ScopeImpl> collectNonExistingFlowScopes(ScopeImpl scope, final MigratingActivityInstanceBranch migratingExecutionBranch) {
        FlowScopeWalker walker = new FlowScopeWalker(scope);
        final LinkedList<ScopeImpl> result = new LinkedList<ScopeImpl>();
        walker.addPreVisitor(new TreeVisitor<ScopeImpl>(){

            @Override
            public void visit(ScopeImpl obj) {
                result.add(0, obj);
            }
        });
        walker.walkWhile(new ReferenceWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                return migratingExecutionBranch.hasInstance(element);
            }
        });
        return result;
    }

    protected void instantiateScopes(MigratingActivityInstance ancestorScopeInstance, MigratingActivityInstanceBranch executionBranch, List<ScopeImpl> scopesToInstantiate) {
        if (scopesToInstantiate.isEmpty()) {
            return;
        }
        ExecutionEntity newParentExecution = ancestorScopeInstance.createAttachableExecution();
        Map<PvmActivity, PvmExecutionImpl> createdExecutions = newParentExecution.instantiateScopes(scopesToInstantiate);
        for (ScopeImpl scope : scopesToInstantiate) {
            ExecutionEntity createdExecution = (ExecutionEntity)createdExecutions.get(scope);
            createdExecution.setActivity(null);
            executionBranch.visited(new MigratingActivityInstance(scope, createdExecution));
        }
    }

    protected void ensureProcessInstanceExist(String processInstanceId, ExecutionEntity processInstance) {
        if (processInstance == null) {
            throw LOGGER.processInstanceDoesNotExist(processInstanceId);
        }
    }

    protected void ensureSameProcessDefinition(ExecutionEntity processInstance, String processDefinitionId) {
        if (!processDefinitionId.equals(processInstance.getProcessDefinitionId())) {
            throw LOGGER.processDefinitionOfInstanceDoesNotMatchMigrationPlan(processInstance, processDefinitionId);
        }
    }
}

