/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationPlanValidationReportImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;

public class MigrationLogger
extends ProcessEngineLogger {
    public MigrationPlanValidationException failingMigrationPlanValidation(MigrationPlanValidationReportImpl validationReport) {
        StringBuilder sb = new StringBuilder();
        validationReport.writeTo(sb);
        return new MigrationPlanValidationException(this.exceptionMessage("001", "{}", new Object[]{sb.toString()}), validationReport);
    }

    public ProcessEngineException processDefinitionOfInstanceDoesNotMatchMigrationPlan(ExecutionEntity processInstance, String processDefinitionId) {
        return new ProcessEngineException(this.exceptionMessage("002", "Process instance '{}' cannot be migrated. Its process definition '{}' does not match the source process definition of the migration plan '{}'", new Object[]{processInstance.getId(), processInstance.getProcessDefinitionId(), processDefinitionId}));
    }

    public ProcessEngineException processInstanceDoesNotExist(String processInstanceId) {
        return new ProcessEngineException(this.exceptionMessage("003", "Process instance '{}' cannot be migrated. The process instance does not exist", new Object[]{processInstanceId}));
    }

    public MigratingProcessInstanceValidationException failingMigratingProcessInstanceValidation(MigratingProcessInstanceValidationReportImpl validationReport) {
        StringBuilder sb = new StringBuilder();
        validationReport.writeTo(sb);
        return new MigratingProcessInstanceValidationException(this.exceptionMessage("004", "{}", new Object[]{sb.toString()}), validationReport);
    }

    public ProcessEngineException cannotBecomeSubordinateInNonScope(MigratingActivityInstance activityInstance) {
        return new ProcessEngineException(this.exceptionMessage("005", "{}", new Object[]{"Cannot attach a subordinate to activity instance '{}'. Activity '{}' is not a scope", activityInstance.getActivityInstance().getId(), activityInstance.getActivityInstance().getActivityId()}));
    }

    public ProcessEngineException cannotDestroySubordinateInNonScope(MigratingActivityInstance activityInstance) {
        return new ProcessEngineException(this.exceptionMessage("006", "{}", new Object[]{"Cannot destroy a subordinate of activity instance '{}'. Activity '{}' is not a scope", activityInstance.getActivityInstance().getId(), activityInstance.getActivityInstance().getActivityId()}));
    }
}

