/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.batch;

import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;

public class MigrateProcessInstanceBatchCmd
implements Command<Batch> {
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected MigrationPlanExecutionBuilderImpl migrationPlanExecutionBuilder;

    public MigrateProcessInstanceBatchCmd(MigrationPlanExecutionBuilderImpl migrationPlanExecutionBuilder) {
        this.migrationPlanExecutionBuilder = migrationPlanExecutionBuilder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchEntity batch = this.createBatch(commandContext);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected BatchEntity createBatch(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler<MigrationBatchConfiguration> batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        MigrationBatchConfiguration configuration = this.createConfiguration();
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setSize(configuration.getProcessInstanceIds().size());
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        commandContext.getBatchManager().insert(batch);
        return batch;
    }

    protected MigrationBatchConfiguration createConfiguration() {
        MigrationPlan migrationPlan = this.migrationPlanExecutionBuilder.getMigrationPlan();
        List<String> processInstanceIds = this.migrationPlanExecutionBuilder.getProcessInstanceIds();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Migration plan cannot be null", "migration plan", (Object)migrationPlan);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be null or empty", "process instance ids", processInstanceIds);
        MigrationBatchConfiguration configuration = new MigrationBatchConfiguration();
        configuration.setMigrationPlan(migrationPlan);
        configuration.setProcessInstanceIds(processInstanceIds);
        return configuration;
    }

    protected BatchJobHandler<MigrationBatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("instance-migration");
    }
}

