/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.batch;

import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.MigrationBatchConfigurationJsonConverter;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;
import org.camunda.bpm.engine.impl.util.json.JSONTokener;
import org.camunda.bpm.engine.migration.MigrationPlan;

public class MigrationBatchJobHandler
implements BatchJobHandler<MigrationBatchConfiguration> {
    public static final MigrationBatchJobDeclaration JOB_DECLARATION = new MigrationBatchJobDeclaration();

    @Override
    public String getType() {
        return "instance-migration";
    }

    @Override
    public JobDeclaration<?, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    public byte[] writeConfiguration(MigrationBatchConfiguration configuration) {
        JSONObject jsonObject = MigrationBatchConfigurationJsonConverter.INSTANCE.toJsonObject(configuration);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Writer writer = StringUtil.writerForStream(outStream);
        jsonObject.write(writer);
        IoUtil.flushSilently(writer);
        return outStream.toByteArray();
    }

    @Override
    public MigrationBatchConfiguration readConfiguration(byte[] serializedConfiguration) {
        Reader jsonReader = StringUtil.readerFromBytes(serializedConfiguration);
        return MigrationBatchConfigurationJsonConverter.INSTANCE.toObject(new JSONObject(new JSONTokener(jsonReader)));
    }

    @Override
    public boolean createJobs(BatchEntity batch) {
        CommandContext commandContext = Context.getCommandContext();
        ByteArrayManager byteArrayManager = commandContext.getByteArrayManager();
        JobManager jobManager = commandContext.getJobManager();
        MigrationBatchConfiguration configuration = this.readConfiguration(batch.getConfigurationBytes());
        MigrationPlan migrationPlan = configuration.getMigrationPlan();
        int batchJobsPerSeed = batch.getBatchJobsPerSeed();
        int invocationsPerBatchJob = batch.getInvocationsPerBatchJob();
        JobDefinitionEntity jobDefinition = batch.getBatchJobDefinition();
        List<String> processInstanceIds = configuration.getProcessInstanceIds();
        int numberOfInstancesToProcess = Math.min(invocationsPerBatchJob * batchJobsPerSeed, processInstanceIds.size());
        List<String> processInstancesToProcess = processInstanceIds.subList(0, numberOfInstancesToProcess);
        while (!processInstancesToProcess.isEmpty()) {
            int lastIdIndex = Math.min(invocationsPerBatchJob, processInstancesToProcess.size());
            List<String> idsForJob = processInstancesToProcess.subList(0, lastIdIndex);
            MigrationBatchConfiguration jobConfiguration = this.createConfigurationForIds(migrationPlan, idsForJob);
            ByteArrayEntity configurationEntity = this.saveConfiguration(byteArrayManager, jobConfiguration);
            JobEntity job = this.createBatchJob(jobDefinition, configurationEntity);
            jobManager.insertJob(job);
            idsForJob.clear();
        }
        batch.setConfigurationBytes(this.writeConfiguration(configuration));
        return processInstanceIds.isEmpty();
    }

    protected MigrationBatchConfiguration createConfigurationForIds(MigrationPlan migrationPlan, List<String> idsForJob) {
        MigrationBatchConfiguration jobConfiguration = new MigrationBatchConfiguration();
        jobConfiguration.setMigrationPlan(migrationPlan);
        jobConfiguration.setProcessInstanceIds(new ArrayList<String>(idsForJob));
        return jobConfiguration;
    }

    protected ByteArrayEntity saveConfiguration(ByteArrayManager byteArrayManager, MigrationBatchConfiguration jobConfiguration) {
        ByteArrayEntity configurationEntity = new ByteArrayEntity();
        configurationEntity.setBytes(this.writeConfiguration(jobConfiguration));
        byteArrayManager.insert(configurationEntity);
        return configurationEntity;
    }

    protected JobEntity createBatchJob(JobDefinitionEntity jobDefinition, ByteArrayEntity configurationEntity) {
        MessageEntity jobInstance = (MessageEntity)JOB_DECLARATION.createJobInstance(configurationEntity);
        jobInstance.setJobDefinition(jobDefinition);
        return jobInstance;
    }

    @Override
    public void deleteJobs(BatchEntity batch) {
        CommandContext commandContext = Context.getCommandContext();
        List<JobEntity> jobs = commandContext.getJobManager().findJobsByJobDefinitionId(batch.getBatchJobDefinitionId());
        ByteArrayManager byteArrayManager = commandContext.getByteArrayManager();
        for (JobEntity job : jobs) {
            byteArrayManager.deleteByteArrayById(job.getJobHandlerConfiguration());
            job.delete();
        }
    }

    @Override
    public void execute(String configurationId, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ByteArrayEntity configurationEntity = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, configurationId);
        MigrationBatchConfiguration batchConfiguration = this.readConfiguration(configurationEntity.getBytes());
        commandContext.getProcessEngineConfiguration().getRuntimeService().newMigration(batchConfiguration.getMigrationPlan()).processInstanceIds(batchConfiguration.getProcessInstanceIds()).execute();
        commandContext.getByteArrayManager().delete(configurationEntity);
    }
}

