/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.instance.EmergingInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingInstance;
import org.camunda.bpm.engine.impl.migration.instance.RemovingInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.MigrationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ModificationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class MigratingActivityInstance
implements MigratingInstance,
RemovingInstance {
    public static final MigrationLogger MIGRATION_LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected MigrationInstruction migrationInstruction;
    protected ActivityInstance activityInstance;
    protected ExecutionEntity representativeExecution;
    protected List<RemovingInstance> removingDependentInstances = new ArrayList<RemovingInstance>();
    protected List<MigratingInstance> migratingDependentInstances = new ArrayList<MigratingInstance>();
    protected List<EmergingInstance> emergingDependentInstances = new ArrayList<EmergingInstance>();
    protected ScopeImpl sourceScope;
    protected ScopeImpl targetScope;
    protected ScopeImpl currentScope;
    protected Set<MigratingActivityInstance> childInstances = new HashSet<MigratingActivityInstance>();
    protected MigratingActivityInstance parentInstance;
    protected MigratingActivityInstanceBehavior instanceBehavior;

    public MigratingActivityInstance(ActivityInstance activityInstance, MigrationInstruction migrationInstruction, ScopeImpl sourceScope, ScopeImpl targetScope, ExecutionEntity scopeExecution) {
        this.activityInstance = activityInstance;
        this.migrationInstruction = migrationInstruction;
        this.sourceScope = sourceScope;
        this.currentScope = sourceScope;
        this.targetScope = targetScope;
        this.representativeExecution = scopeExecution;
        this.instanceBehavior = this.determineBehavior(sourceScope);
    }

    public MigratingActivityInstance(ScopeImpl targetScope, ExecutionEntity scopeExecution) {
        this.targetScope = targetScope;
        this.currentScope = targetScope;
        this.representativeExecution = scopeExecution;
        this.instanceBehavior = this.determineBehavior(targetScope);
    }

    protected MigratingActivityInstanceBehavior determineBehavior(ScopeImpl scope) {
        if (scope.isScope()) {
            return new MigratingScopeActivityInstanceBehavior();
        }
        return new MigratingNonScopeActivityInstanceBehavior();
    }

    public void detachChildren() {
        HashSet<MigratingActivityInstance> childrenCopy = new HashSet<MigratingActivityInstance>(this.childInstances);
        for (MigratingActivityInstance child : childrenCopy) {
            child.detachDependentInstances();
        }
        for (MigratingActivityInstance child : childrenCopy) {
            child.detachState();
        }
    }

    public void detachDependentInstances() {
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            if (dependentInstance.isDetached()) continue;
            dependentInstance.detachState();
        }
    }

    @Override
    public boolean isDetached() {
        return this.instanceBehavior.isDetached();
    }

    @Override
    public void detachState() {
        this.detachDependentInstances();
        this.instanceBehavior.detachState();
        if (this.parentInstance != null) {
            this.parentInstance.getChildren().remove(this);
            this.parentInstance = null;
        }
    }

    @Override
    public void attachState(MigratingActivityInstance activityInstance) {
        activityInstance.getChildren().add(this);
        this.setParent(activityInstance);
        this.instanceBehavior.attachState(activityInstance);
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.attachState(this);
        }
    }

    @Override
    public void migrateDependentEntities() {
        for (MigratingInstance migratingInstance : this.migratingDependentInstances) {
            migratingInstance.migrateState();
            migratingInstance.migrateDependentEntities();
        }
        ExecutionEntity representativeExecution = this.resolveRepresentativeExecution();
        for (EmergingInstance emergingInstance : this.emergingDependentInstances) {
            emergingInstance.create(representativeExecution);
        }
    }

    public ExecutionEntity resolveRepresentativeExecution() {
        return this.instanceBehavior.resolveRepresentativeExecution();
    }

    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
        this.migratingDependentInstances.add(migratingInstance);
    }

    public List<MigratingInstance> getMigratingDependentInstances() {
        return this.migratingDependentInstances;
    }

    public void addRemovingDependentInstance(RemovingInstance removingInstance) {
        this.removingDependentInstances.add(removingInstance);
    }

    public void addEmergingDependentInstance(EmergingInstance emergingInstance) {
        this.emergingDependentInstances.add(emergingInstance);
    }

    public ActivityInstance getActivityInstance() {
        return this.activityInstance;
    }

    public ScopeImpl getSourceScope() {
        return this.sourceScope;
    }

    public ScopeImpl getTargetScope() {
        return this.targetScope;
    }

    public ScopeImpl getCurrentScope() {
        return this.currentScope;
    }

    public Set<MigratingActivityInstance> getChildren() {
        return this.childInstances;
    }

    public MigratingActivityInstance getParent() {
        return this.parentInstance;
    }

    public void setParent(MigratingActivityInstance parentInstance) {
        this.parentInstance = parentInstance;
    }

    public MigrationInstruction getMigrationInstruction() {
        return this.migrationInstruction;
    }

    public boolean migrates() {
        return this.targetScope != null;
    }

    public void removeUnmappedDependentInstances() {
        for (RemovingInstance removingInstance : this.removingDependentInstances) {
            removingInstance.remove();
        }
    }

    @Override
    public void remove() {
        this.instanceBehavior.remove();
    }

    @Override
    public void migrateState() {
        this.instanceBehavior.migrateState();
    }

    public ExecutionEntity createAttachableExecution() {
        return this.instanceBehavior.createAttachableExecution();
    }

    public void destroyAttachableExecution(ExecutionEntity execution) {
        this.instanceBehavior.destroyAttachableExecution(execution);
    }

    protected class MigratingScopeActivityInstanceBehavior
    implements MigratingActivityInstanceBehavior {
        protected MigratingScopeActivityInstanceBehavior() {
        }

        @Override
        public boolean isDetached() {
            ExecutionEntity representativeExecution = this.resolveRepresentativeExecution();
            return representativeExecution != representativeExecution.getProcessInstance() && representativeExecution.getParent() == null;
        }

        @Override
        public void detachState() {
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            ExecutionEntity parentExecution = currentScopeExecution.getParent();
            currentScopeExecution.setParent(null);
            if (MigratingActivityInstance.this.sourceScope.getActivityBehavior() instanceof CompositeActivityBehavior) {
                parentExecution.leaveActivityInstance();
            }
            MigratingActivityInstance.this.parentInstance.destroyAttachableExecution(parentExecution);
        }

        @Override
        public void attachState(MigratingActivityInstance parentInstance) {
            ExecutionEntity newParentExecution = parentInstance.createAttachableExecution();
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            currentScopeExecution.setParent(newParentExecution);
            if (MigratingActivityInstance.this.sourceScope.getActivityBehavior() instanceof CompositeActivityBehavior) {
                newParentExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
            }
        }

        @Override
        public void migrateState() {
            ExecutionEntity currentScopeExecution = this.resolveRepresentativeExecution();
            currentScopeExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            ExecutionEntity parentExecution = currentScopeExecution.getParent();
            if (parentExecution != null && parentExecution.isConcurrent()) {
                parentExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            }
            MigratingActivityInstance.this.currentScope = MigratingActivityInstance.this.targetScope;
            if (!MigratingActivityInstance.this.targetScope.isScope()) {
                this.becomeNonScope();
                currentScopeExecution = this.resolveRepresentativeExecution();
            }
            if (this.isLeafActivity(MigratingActivityInstance.this.targetScope)) {
                currentScopeExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.targetScope));
            }
            if (MigratingActivityInstance.this.sourceScope.getActivityBehavior() instanceof MigrationObserverBehavior) {
                ((MigrationObserverBehavior)((Object)MigratingActivityInstance.this.sourceScope.getActivityBehavior())).migrateScope(currentScopeExecution);
            }
        }

        protected void becomeNonScope() {
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.detachState();
            }
            ExecutionEntity parentExecution = MigratingActivityInstance.this.representativeExecution.getParent();
            parentExecution.setActivity(MigratingActivityInstance.this.representativeExecution.getActivity());
            parentExecution.setActivityInstanceId(MigratingActivityInstance.this.representativeExecution.getActivityInstanceId());
            MigratingActivityInstance.this.representativeExecution.remove();
            MigratingActivityInstance.this.representativeExecution = parentExecution;
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.attachState(MigratingActivityInstance.this);
            }
            MigratingActivityInstance.this.instanceBehavior = new MigratingNonScopeActivityInstanceBehavior();
        }

        protected boolean isLeafActivity(ScopeImpl scope) {
            return scope.getActivities().isEmpty();
        }

        @Override
        public ExecutionEntity resolveRepresentativeExecution() {
            return MigratingActivityInstance.this.representativeExecution;
        }

        @Override
        public void remove() {
            MigratingActivityInstance.this.parentInstance.getChildren().remove(MigratingActivityInstance.this);
            for (MigratingActivityInstance child : MigratingActivityInstance.this.childInstances) {
                child.parentInstance = null;
            }
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            ExecutionEntity parentExecution = currentExecution.getParent();
            currentExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.sourceScope));
            currentExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
            currentExecution.deleteCascade("migration");
            MigratingActivityInstance.this.parentInstance.destroyAttachableExecution(parentExecution);
        }

        @Override
        public ExecutionEntity createAttachableExecution() {
            ExecutionEntity scopeExecution;
            ExecutionEntity attachableExecution = scopeExecution = this.resolveRepresentativeExecution();
            if (MigratingActivityInstance.this.currentScope.getActivityBehavior() instanceof ModificationObserverBehavior) {
                ModificationObserverBehavior behavior = (ModificationObserverBehavior)MigratingActivityInstance.this.currentScope.getActivityBehavior();
                attachableExecution = (ExecutionEntity)behavior.createInnerInstance(scopeExecution);
            } else if (!scopeExecution.getNonEventScopeExecutions().isEmpty() || scopeExecution.getActivity() != null) {
                attachableExecution = (ExecutionEntity)scopeExecution.createConcurrentExecution();
                scopeExecution.forceUpdate();
            }
            return attachableExecution;
        }

        @Override
        public void destroyAttachableExecution(ExecutionEntity execution) {
            if (MigratingActivityInstance.this.currentScope.getActivityBehavior() instanceof ModificationObserverBehavior) {
                ModificationObserverBehavior behavior = (ModificationObserverBehavior)MigratingActivityInstance.this.currentScope.getActivityBehavior();
                behavior.destroyInnerInstance(execution);
            } else if (execution.isConcurrent()) {
                execution.remove();
                execution.getParent().tryPruneLastConcurrentChild();
                execution.getParent().forceUpdate();
            }
        }
    }

    protected class MigratingNonScopeActivityInstanceBehavior
    implements MigratingActivityInstanceBehavior {
        protected MigratingNonScopeActivityInstanceBehavior() {
        }

        @Override
        public boolean isDetached() {
            return this.resolveRepresentativeExecution().getActivity() == null;
        }

        @Override
        public void detachState() {
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution.setActivity(null);
            currentExecution.leaveActivityInstance();
            MigratingActivityInstance.this.parentInstance.destroyAttachableExecution(currentExecution);
        }

        @Override
        public void attachState(MigratingActivityInstance newParentInstance) {
            MigratingActivityInstance.this.representativeExecution = newParentInstance.createAttachableExecution();
            MigratingActivityInstance.this.representativeExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.sourceScope));
            MigratingActivityInstance.this.representativeExecution.setActivityInstanceId(MigratingActivityInstance.this.activityInstance.getId());
        }

        @Override
        public void migrateState() {
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution.setProcessDefinition(MigratingActivityInstance.this.targetScope.getProcessDefinition());
            currentExecution.setActivity((PvmActivity)((Object)MigratingActivityInstance.this.targetScope));
            MigratingActivityInstance.this.currentScope = MigratingActivityInstance.this.targetScope;
            if (MigratingActivityInstance.this.targetScope.isScope()) {
                this.becomeScope();
            }
        }

        protected void becomeScope() {
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.detachState();
            }
            ExecutionEntity currentExecution = this.resolveRepresentativeExecution();
            currentExecution = currentExecution.createExecution();
            ExecutionEntity parent = currentExecution.getParent();
            parent.setActivity(null);
            if (!parent.isConcurrent()) {
                parent.leaveActivityInstance();
            }
            MigratingActivityInstance.this.representativeExecution = currentExecution;
            for (MigratingInstance dependentInstance : MigratingActivityInstance.this.migratingDependentInstances) {
                dependentInstance.attachState(MigratingActivityInstance.this);
            }
            MigratingActivityInstance.this.instanceBehavior = new MigratingScopeActivityInstanceBehavior();
        }

        @Override
        public ExecutionEntity resolveRepresentativeExecution() {
            if (MigratingActivityInstance.this.representativeExecution.getReplacedBy() != null) {
                return MigratingActivityInstance.this.representativeExecution.resolveReplacedBy();
            }
            return MigratingActivityInstance.this.representativeExecution;
        }

        @Override
        public void remove() {
        }

        @Override
        public ExecutionEntity createAttachableExecution() {
            throw MIGRATION_LOGGER.cannotBecomeSubordinateInNonScope(MigratingActivityInstance.this);
        }

        @Override
        public void destroyAttachableExecution(ExecutionEntity execution) {
            throw MIGRATION_LOGGER.cannotDestroySubordinateInNonScope(MigratingActivityInstance.this);
        }
    }

    protected static interface MigratingActivityInstanceBehavior {
        public boolean isDetached();

        public void detachState();

        public void attachState(MigratingActivityInstance var1);

        public void migrateState();

        public void remove();

        public ExecutionEntity resolveRepresentativeExecution();

        public ExecutionEntity createAttachableExecution();

        public void destroyAttachableExecution(ExecutionEntity var1);
    }
}

