/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingInstance;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class MigratingIncident
implements MigratingInstance {
    protected IncidentEntity incident;
    protected ScopeImpl targetScope;

    public MigratingIncident(IncidentEntity incident, ScopeImpl targetScope) {
        this.incident = incident;
        this.targetScope = targetScope;
    }

    @Override
    public boolean isDetached() {
        return this.incident.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.incident.setExecution(null);
    }

    @Override
    public void attachState(MigratingActivityInstance newOwningInstance) {
        this.incident.setExecution(newOwningInstance.resolveRepresentativeExecution());
    }

    @Override
    public void migrateState() {
        this.incident.setActivityId(this.targetScope.getId());
        this.incident.setProcessDefinitionId(this.targetScope.getProcessDefinition().getId());
    }

    @Override
    public void migrateDependentEntities() {
    }
}

