/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class MigratingProcessInstance {
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected String processInstanceId;
    protected Map<String, MigratingActivityInstance> migratingActivityInstances;

    public MigratingProcessInstance(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        this.migratingActivityInstances = new HashMap<String, MigratingActivityInstance>();
    }

    public Collection<MigratingActivityInstance> getMigratingActivityInstances() {
        return this.migratingActivityInstances.values();
    }

    public MigratingActivityInstance getMigratingInstance(String activityInstanceId) {
        return this.migratingActivityInstances.get(activityInstanceId);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public MigratingActivityInstance addActivityInstance(MigrationInstruction migrationInstruction, ActivityInstance activityInstance, ScopeImpl sourceScope, ScopeImpl targetScope, ExecutionEntity scopeExecution) {
        MigratingActivityInstance migratingActivityInstance = new MigratingActivityInstance(activityInstance, migrationInstruction, sourceScope, targetScope, scopeExecution);
        this.migratingActivityInstances.put(activityInstance.getId(), migratingActivityInstance);
        return migratingActivityInstance;
    }
}

