/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class MigratingVariableInstance
implements MigratingInstance {
    protected VariableInstanceEntity variable;
    protected boolean isConcurrentLocalInParentScope;

    public MigratingVariableInstance(VariableInstanceEntity variable, boolean isConcurrentLocalInParentScope) {
        this.variable = variable;
        this.isConcurrentLocalInParentScope = isConcurrentLocalInParentScope;
    }

    @Override
    public boolean isDetached() {
        return this.variable.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.variable.getExecution().removeVariableInternal(this.variable);
    }

    @Override
    public void attachState(MigratingActivityInstance owningActivityInstance) {
        ExecutionEntity representativeExecution = owningActivityInstance.resolveRepresentativeExecution();
        ScopeImpl currentScope = owningActivityInstance.getCurrentScope();
        ExecutionEntity newOwningExecution = representativeExecution;
        if (currentScope.isScope() && this.isConcurrentLocalInParentScope) {
            newOwningExecution = representativeExecution.getParent();
        }
        newOwningExecution.addVariableInternal(this.variable);
    }

    @Override
    public void migrateState() {
    }

    @Override
    public void migrateDependentEntities() {
    }

    public String getVariableName() {
        return this.variable.getName();
    }
}

