/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.impl.core.delegate.CoreActivityBehavior;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.MigrationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class ActivityInstanceHandler
implements MigratingInstanceParseHandler<ActivityInstance> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, ActivityInstance element) {
        CoreActivityBehavior<? extends BaseDelegateExecution> sourceActivityBehavior;
        MigratingActivityInstance migratingInstance = null;
        MigrationInstruction applyingInstruction = parseContext.getInstructionFor(element.getActivityId());
        ScopeImpl sourceScope = null;
        ScopeImpl targetScope = null;
        ExecutionEntity representativeExecution = parseContext.getMapping().getExecution(element);
        if (element.getId().equals(element.getProcessInstanceId())) {
            sourceScope = parseContext.getSourceProcessDefinition();
            targetScope = parseContext.getTargetProcessDefinition();
        } else {
            sourceScope = parseContext.getSourceProcessDefinition().findActivity(element.getActivityId());
            if (applyingInstruction != null) {
                String activityId = applyingInstruction.getTargetActivityId();
                targetScope = parseContext.getTargetProcessDefinition().findActivity(activityId);
            }
        }
        migratingInstance = parseContext.getMigratingProcessInstance().addActivityInstance(applyingInstruction, element, sourceScope, targetScope, representativeExecution);
        MigratingActivityInstance parentInstance = parseContext.getMigratingActivityInstanceById(element.getParentActivityInstanceId());
        if (parentInstance != null) {
            parentInstance.getChildren().add(migratingInstance);
            migratingInstance.setParent(parentInstance);
        }
        if ((sourceActivityBehavior = sourceScope.getActivityBehavior()) instanceof MigrationObserverBehavior) {
            ((MigrationObserverBehavior)((Object)sourceActivityBehavior)).onParseMigratingInstance(parseContext, migratingInstance);
        }
        parseContext.submit(migratingInstance);
        this.parseDependentInstances(parseContext, migratingInstance);
    }

    public void parseDependentInstances(MigratingInstanceParseContext parseContext, MigratingActivityInstance migratingInstance) {
        parseContext.handleDependentJobs(migratingInstance, migratingInstance.resolveRepresentativeExecution().getJobs());
        parseContext.handleDependentEventSubscriptions(migratingInstance, migratingInstance.resolveRepresentativeExecution().getEventSubscriptions());
        parseContext.handleDependentTasks(migratingInstance, migratingInstance.resolveRepresentativeExecution().getTasks());
        parseContext.handleDependentVariables(migratingInstance, this.collectActivityInstanceVariables(migratingInstance));
    }

    protected List<VariableInstanceEntity> collectActivityInstanceVariables(MigratingActivityInstance instance) {
        boolean addAnyParentExecutionVariables;
        boolean addAllRepresentativeExecutionVariables;
        ArrayList<VariableInstanceEntity> variables = new ArrayList<VariableInstanceEntity>();
        ExecutionEntity representativeExecution = instance.resolveRepresentativeExecution();
        ExecutionEntity parentExecution = representativeExecution.getParent();
        boolean bl = addAllRepresentativeExecutionVariables = instance.getSourceScope().isScope() || representativeExecution.isConcurrent();
        if (addAllRepresentativeExecutionVariables) {
            variables.addAll(representativeExecution.getVariablesInternal());
        } else {
            variables.addAll(this.getConcurrentLocalVariables(representativeExecution));
        }
        boolean bl2 = addAnyParentExecutionVariables = parentExecution != null && instance.getSourceScope().isScope();
        if (addAnyParentExecutionVariables) {
            boolean addAllParentExecutionVariables = parentExecution.isConcurrent();
            if (addAllParentExecutionVariables) {
                variables.addAll(parentExecution.getVariablesInternal());
            } else {
                variables.addAll(this.getConcurrentLocalVariables(parentExecution));
            }
        }
        return variables;
    }

    protected List<VariableInstanceEntity> getConcurrentLocalVariables(ExecutionEntity execution) {
        ArrayList<VariableInstanceEntity> variables = new ArrayList<VariableInstanceEntity>();
        for (VariableInstanceEntity variable : execution.getVariablesInternal()) {
            if (!variable.isConcurrentLocal()) continue;
            variables.add(variable);
        }
        return variables;
    }
}

