/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingEventSubscriptionInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class EventSubscriptionInstanceHandler
implements MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<EventSubscriptionEntity>> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, MigratingActivityInstance owningInstance, List<EventSubscriptionEntity> elements) {
        ArrayList<String> migratedEventSubscriptionTargetActivityIds = new ArrayList<String>();
        for (EventSubscriptionEntity eventSubscription : elements) {
            MigrationInstruction eventSubscriptionMigrationInstruction = parseContext.findSingleMigrationInstruction(eventSubscription.getActivityId());
            if (eventSubscriptionMigrationInstruction != null) {
                ActivityImpl eventSubscriptionTargetActivity = parseContext.getTargetProcessDefinition().findActivity(eventSubscriptionMigrationInstruction.getTargetActivityId());
                migratedEventSubscriptionTargetActivityIds.add(eventSubscriptionTargetActivity.getId());
                owningInstance.addMigratingDependentInstance(new MigratingEventSubscriptionInstance(eventSubscription, eventSubscriptionTargetActivity));
            } else {
                owningInstance.addRemovingDependentInstance(new MigratingEventSubscriptionInstance(eventSubscription));
            }
            parseContext.consume(eventSubscription);
        }
        if (owningInstance.getTargetScope() != null) {
            for (EventSubscriptionDeclaration eventSubscriptionDeclaration : EventSubscriptionDeclaration.getDeclarationsForScope(owningInstance.getTargetScope())) {
                if (migratedEventSubscriptionTargetActivityIds.contains(eventSubscriptionDeclaration.getActivityId())) continue;
                owningInstance.addEmergingDependentInstance(new MigratingEventSubscriptionInstance(eventSubscriptionDeclaration));
            }
        }
    }
}

