/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.migration.instance.EmergingJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class JobInstanceHandler
implements MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, MigratingActivityInstance activityInstance, List<JobEntity> elements) {
        ArrayList<String> migratingActivityIds = new ArrayList<String>();
        for (JobEntity job : elements) {
            if (!JobInstanceHandler.isTimerJob(job)) continue;
            MigrationInstruction timerJobMigrationInstruction = parseContext.getInstructionFor(job.getActivityId());
            if (timerJobMigrationInstruction != null) {
                ActivityImpl timerJobTargetActivity = parseContext.getTargetProcessDefinition().findActivity(timerJobMigrationInstruction.getTargetActivityId());
                migratingActivityIds.add(timerJobTargetActivity.getId());
                JobDefinitionEntity targetJobDefinitionEntity = parseContext.getTargetJobDefinition(timerJobTargetActivity.getActivityId(), job.getJobHandlerType());
                MigratingJobInstance migratingTimerJobInstance = new MigratingJobInstance(job, targetJobDefinitionEntity, timerJobTargetActivity);
                activityInstance.addMigratingDependentInstance(migratingTimerJobInstance);
                parseContext.submit(migratingTimerJobInstance);
            } else {
                MigratingJobInstance removingJobInstance = new MigratingJobInstance(job);
                activityInstance.addRemovingDependentInstance(removingJobInstance);
                parseContext.submit(removingJobInstance);
            }
            parseContext.consume(job);
        }
        ArrayList<TimerDeclarationImpl> emergingTimerDeclarations = new ArrayList<TimerDeclarationImpl>();
        if (activityInstance.getTargetScope() != null) {
            for (TimerDeclarationImpl timerDeclaration : TimerDeclarationImpl.getDeclarationsForScope(activityInstance.getTargetScope())) {
                if (migratingActivityIds.contains(timerDeclaration.getActivityId())) continue;
                emergingTimerDeclarations.add(timerDeclaration);
            }
        }
        for (TimerDeclarationImpl emergingDeclaration : emergingTimerDeclarations) {
            activityInstance.addEmergingDependentInstance(new EmergingJobInstance(emergingDeclaration));
        }
    }

    protected static boolean isTimerJob(JobEntity job) {
        return job != null && job.getType().equals("timer");
    }
}

