/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.ActivityInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.ActivityInstanceWalker;
import org.camunda.bpm.engine.impl.migration.instance.parser.EventSubscriptionInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.IncidentInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.JobInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.TaskInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.VariableInstanceHandler;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class MigratingInstanceParser {
    protected ProcessEngine engine;
    protected MigratingInstanceParseHandler<ActivityInstance> activityInstanceHandler = new ActivityInstanceHandler();
    protected MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> dependentJobHandler = new JobInstanceHandler();
    protected MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<EventSubscriptionEntity>> dependentEventSubscriptionHandler = new EventSubscriptionInstanceHandler();
    protected MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<TaskEntity>> dependentTaskHandler = new TaskInstanceHandler();
    protected MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<VariableInstanceEntity>> dependentVariableHandler = new VariableInstanceHandler();
    protected MigratingInstanceParseHandler<IncidentEntity> incidentHandler = new IncidentInstanceHandler();

    public MigratingInstanceParser(ProcessEngine engine) {
        this.engine = engine;
    }

    public MigratingProcessInstance parse(String processInstanceId, MigrationPlan migrationPlan, MigratingProcessInstanceValidationReportImpl processInstanceReport) {
        CommandContext commandContext = Context.getCommandContext();
        List<ExecutionEntity> executions = this.fetchExecutions(commandContext, processInstanceId);
        List<EventSubscriptionEntity> eventSubscriptions = this.fetchEventSubscriptions(commandContext, processInstanceId);
        List<TaskEntity> tasks = this.fetchTasks(commandContext, processInstanceId);
        List<JobEntity> jobs = this.fetchJobs(commandContext, processInstanceId);
        List<IncidentEntity> incidents = this.fetchIncidents(commandContext, processInstanceId);
        List<VariableInstanceEntity> variables = this.fetchVariables(commandContext, processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        processInstance.restoreProcessInstance(executions, eventSubscriptions, variables, tasks, jobs, incidents);
        ProcessDefinitionEntity targetProcessDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(migrationPlan.getTargetProcessDefinitionId());
        List<JobDefinitionEntity> targetJobDefinitions = this.fetchJobDefinitions(commandContext, targetProcessDefinition.getId());
        final MigratingInstanceParseContext parseContext = new MigratingInstanceParseContext(this, migrationPlan, processInstance, targetProcessDefinition).jobs(jobs).eventSubscriptions(eventSubscriptions).incidents(incidents).tasks(tasks).targetJobDefinitions(targetJobDefinitions).variables(variables);
        ActivityInstance activityInstance = this.engine.getRuntimeService().getActivityInstance(processInstanceId);
        ActivityInstanceWalker activityInstanceWalker = new ActivityInstanceWalker(activityInstance);
        activityInstanceWalker.addPreVisitor(new TreeVisitor<ActivityInstance>(){

            @Override
            public void visit(ActivityInstance obj) {
                MigratingInstanceParser.this.activityInstanceHandler.handle(parseContext, obj);
            }
        });
        activityInstanceWalker.walkWhile();
        for (IncidentEntity incidentEntity : incidents) {
            this.incidentHandler.handle(parseContext, incidentEntity);
        }
        parseContext.validateNoEntitiesLeft(processInstanceReport);
        return parseContext.getMigratingProcessInstance();
    }

    public MigratingInstanceParseHandler<ActivityInstance> getActivityInstanceHandler() {
        return this.activityInstanceHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<EventSubscriptionEntity>> getDependentEventSubscriptionHandler() {
        return this.dependentEventSubscriptionHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> getDependentJobHandler() {
        return this.dependentJobHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<TaskEntity>> getDependentTaskHandler() {
        return this.dependentTaskHandler;
    }

    public MigratingInstanceParseHandler<IncidentEntity> getIncidentHandler() {
        return this.incidentHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<VariableInstanceEntity>> getDependentVariablesHandler() {
        return this.dependentVariableHandler;
    }

    protected List<ExecutionEntity> fetchExecutions(CommandContext commandContext, String processInstanceId) {
        return commandContext.getExecutionManager().findExecutionsByProcessInstanceId(processInstanceId);
    }

    protected List<EventSubscriptionEntity> fetchEventSubscriptions(CommandContext commandContext, String processInstanceId) {
        return commandContext.getEventSubscriptionManager().findEventSubscriptionsByProcessInstanceId(processInstanceId);
    }

    protected List<JobEntity> fetchJobs(CommandContext commandContext, String processInstanceId) {
        return commandContext.getJobManager().findJobsByProcessInstanceId(processInstanceId);
    }

    protected List<IncidentEntity> fetchIncidents(CommandContext commandContext, String processInstanceId) {
        return commandContext.getIncidentManager().findIncidentsByProcessInstance(processInstanceId);
    }

    protected List<TaskEntity> fetchTasks(CommandContext commandContext, String processInstanceId) {
        return commandContext.getTaskManager().findTasksByProcessInstanceId(processInstanceId);
    }

    protected List<JobDefinitionEntity> fetchJobDefinitions(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getJobDefinitionManager().findByProcessDefinitionId(processDefinitionId);
    }

    protected List<VariableInstanceEntity> fetchVariables(CommandContext commandContext, String processInstanceId) {
        return commandContext.getVariableInstanceManager().findVariableInstancesByProcessInstanceId(processInstanceId);
    }
}

