/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.activity;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.migration.validation.activity.MigrationActivityValidator;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class SupportedBoundaryEventActivityValidator
implements MigrationActivityValidator {
    public static SupportedBoundaryEventActivityValidator INSTANCE = new SupportedBoundaryEventActivityValidator();
    public static final List<String> supportedTypes = Arrays.asList("boundaryMessage", "boundarySignal", "boundaryTimer");

    @Override
    public boolean valid(ActivityImpl activity) {
        return activity != null && (!this.isBoundaryEvent(activity) || this.isSupportedBoundaryEventType(activity));
    }

    public boolean isBoundaryEvent(ActivityImpl activity) {
        return activity.getActivityBehavior() instanceof BoundaryEventActivityBehavior;
    }

    public boolean isSupportedBoundaryEventType(ActivityImpl activity) {
        return supportedTypes.contains(activity.getProperties().get(BpmnProperties.TYPE));
    }
}

