/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instance;

import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class AdditionalFlowScopeActivityInstanceValidator
implements MigratingActivityInstanceValidator {
    @Override
    public void validate(MigratingActivityInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingActivityInstanceValidationReportImpl instanceReport) {
        ScopeImpl parentInstanceTargetScope;
        MigratingActivityInstance ancestorInstance = this.getClosestPreservedAncestorInstance(migratingInstance);
        ScopeImpl targetScope = migratingInstance.getTargetScope();
        if (ancestorInstance != null && targetScope != null && targetScope != targetScope.getProcessDefinition() && (parentInstanceTargetScope = ancestorInstance.getTargetScope()) != null && !parentInstanceTargetScope.isAncestorFlowScopeOf(targetScope)) {
            instanceReport.addFailure("Closest migrating ancestor activity instance is migrated to activity '" + parentInstanceTargetScope.getId() + "' which is not an ancestor of target activity '" + targetScope.getId() + "'");
        }
    }

    protected MigratingActivityInstance getClosestPreservedAncestorInstance(MigratingActivityInstance activityInstance) {
        MigratingActivityInstance parent;
        for (parent = activityInstance.getParent(); parent != null && parent.getTargetScope() == null; parent = parent.getParent()) {
        }
        return parent;
    }
}

