/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instance;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReport;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationReport;

public class MigratingProcessInstanceValidationReportImpl
implements MigratingProcessInstanceValidationReport {
    protected String processInstanceId;
    protected List<MigratingActivityInstanceValidationReport> reports = new ArrayList<MigratingActivityInstanceValidationReport>();
    protected List<String> failures = new ArrayList<String>();

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void addInstanceReport(MigratingActivityInstanceValidationReport instanceReport) {
        this.reports.add(instanceReport);
    }

    @Override
    public List<MigratingActivityInstanceValidationReport> getReports() {
        return this.reports;
    }

    public void addFailure(String failure) {
        this.failures.add(failure);
    }

    @Override
    public List<String> getFailures() {
        return this.failures;
    }

    @Override
    public boolean hasFailures() {
        return !this.failures.isEmpty() || !this.reports.isEmpty();
    }

    public void writeTo(StringBuilder sb) {
        sb.append("Cannot migrate process instance '").append(this.processInstanceId).append("':\n");
        for (String failure : this.failures) {
            sb.append("\t").append(failure).append("\n");
        }
        for (MigratingActivityInstanceValidationReport report : this.reports) {
            sb.append("\tCannot migrate activity instance '").append(report.getActivityInstanceId()).append("':\n");
            for (String failure : report.getFailures()) {
                sb.append("\t\t").append(failure).append("\n");
            }
        }
    }
}

