/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instance;

import java.util.Arrays;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.TransitionInstance;

public class NoActiveTransitionsActivityInstanceValidator
implements MigratingActivityInstanceValidator {
    @Override
    public void validate(MigratingActivityInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingActivityInstanceValidationReportImpl instanceReport) {
        TransitionInstance[] childTransitionInstances = migratingInstance.getActivityInstance().getChildTransitionInstances();
        if (this.hasAsyncTransitionInstances(migratingInstance.getActivityInstance())) {
            instanceReport.addFailure("Has active asynchronous child transitions: [" + StringUtil.joinProcessElementInstanceIds(Arrays.asList(childTransitionInstances)) + "]");
        }
    }

    protected boolean hasAsyncTransitionInstances(ActivityInstance activityInstance) {
        for (TransitionInstance childTransitionInstance : activityInstance.getChildTransitionInstances()) {
            String executionId = childTransitionInstance.getExecutionId();
            ExecutionEntity execution = Context.getCommandContext().getExecutionManager().findExecutionById(executionId);
            for (JobEntity job : execution.getJobs()) {
                if (!"async-continuation".equals(job.getJobHandlerType())) continue;
                return true;
            }
        }
        return false;
    }
}

